function varargout = Lazy(varargin)
% LAZY M-file for Lazy.fig
%      LAZY, by itself, creates a new LAZY or raises the existing
%      singleton*.
%
%      H = LAZY returns the handle to a new LAZY or the handle to
%      the existing singleton*.
%
%      LAZY('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LAZY.M with the given input arguments.
%
%      LAZY('Property','Value',...) creates a new LAZY or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Lazy_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Lazy_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Copyright 2002-2003 The MathWorks, Inc.

% Edit the above text to modify the response to help Lazy

% Last Modified by GUIDE v2.5 19-Apr-2005 22:28:23

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
  'gui_Singleton',  gui_Singleton, ...
  'gui_OpeningFcn', @Lazy_OpeningFcn, ...
  'gui_OutputFcn',  @Lazy_OutputFcn, ...
  'gui_LayoutFcn',  [] , ...
  'gui_Callback',   []);
if nargin && ischar(varargin{1})
  gui_State.gui_Callback = str2func(varargin{1});
  %    disp(varargin{1});
end

if nargout
  [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
  gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Lazy is made visible.
function Lazy_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Lazy (see VARARGIN)

addpath(pwd);

[logodata, map, alpha] = imread('hutlogo3','png');
imagesc(logodata),colormap(map);
axis([106 321 71 346]);
axis off;

% Choose default command line output for Lazy
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Lazy wait for user response (see UIRESUME)
% uiwait(handles.lazy);


% --- Outputs from this function are returned to the command line.
function varargout = Lazy_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in databrowse.
function databrowse_Callback(hObject, eventdata, handles)
% hObject    handle to databrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inidir = pwd;
datadir = get(handles.data, 'string');

try
  [pathstr] = fileparts(datadir);
  cd(pathstr);
catch
  % Nothing here...
end

[loadfile, loadpath] = uigetfile('*.*', 'Load Data');

if ~isequal(loadfile, 0) & ~isequal(loadpath, 0)
  set(handles.data, 'string', [loadpath loadfile]);
end

cd(inidir);

% --- Executes on button press in realvaluebrowse.
function realvaluebrowse_Callback(hObject, eventdata, handles)
% hObject    handle to realvaluebrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inidir = pwd;
realvaluedir = get(handles.realvalues, 'string');

if ~isempty(realvaluedir)
  try
    [pathstr] = fileparts(realvaluedir);
    cd(pathstr);
  catch
    % Nothing here...
  end
end

[loadfile, loadpath] = uigetfile('*.*', 'Load Continued Data');

if ~isequal(loadfile, 0) & ~isequal(loadpath, 0)
  set(handles.realvalues, 'string', [loadpath loadfile]);
end

cd(inidir);


function working(state, handles)
% This function enables or disables all
% functional units of Lazy Learning Toolbox according to state.

set(handles.data, 'enable', state);
set(handles.datatext, 'enable', state);
set(handles.databrowse, 'enable', state);

set(handles.realvalues, 'enable', state);
set(handles.realvaltext, 'enable', state);
set(handles.realvaluebrowse, 'enable', state);

set(handles.testset, 'enable', state);
set(handles.testsettext, 'enable', state);
set(handles.testsetbrowse, 'enable', state);

set(handles.methodtext, 'enable', state);
set(handles.method, 'enable', state);
set(handles.pruning, 'enable', state);

set(handles.samplingtext, 'enable', state);
set(handles.sampling, 'enable', state);
set(handles.rounds, 'enable', state);

set(handles.neighborstext, 'enable', state);
set(handles.neighbors, 'enable', state);
set(handles.glneighbors, 'enable', state);

set(handles.regressortext, 'enable', state);
set(handles.regressor, 'enable', state);

set(handles.predmethodtext, 'enable', state);
set(handles.predmethod, 'enable', state);

set(handles.stepstext, 'enable', state);
set(handles.steps, 'enable', state);

set(handles.learn, 'enable', state);
set(handles.predict, 'enable', state);

set(handles.loadsetting, 'enable', state);
set(handles.savesetting, 'enable', state);
set(handles.saveresults, 'enable', state);
set(handles.testerror, 'enable', state);

if strcmp(state, 'on')
  method_Callback(handles.method, 0, handles);
  pruning_Callback(handles.pruning, 0, handles);
  sampling_Callback(handles.sampling, 0, handles);
end

% --- Executes on selection change in pruning.
function pruning_Callback(hObject, eventdata, handles)
% hObject    handle to pruning (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns pruning contents as cell array
%        contents{get(hObject,'Value')} returns selected item from pruning

switch get(hObject,'value')
  case 1
    switch get(handles.method, 'value')
      case 1
        set(handles.glneighbors, 'enable', 'off');
      case 2
        set(handles.glneighbors, 'enable', 'on');
      case 3
        set(handles.glneighbors, 'enable', 'off');
        set(handles.glneighbors, 'value', 1);
    end

  case 2
    switch get(handles.method, 'value')
      case 1
        set(handles.glneighbors, 'enable', 'off');
      case 2
        set(handles.glneighbors, 'enable', 'on');
      case 3
        set(handles.glneighbors, 'enable', 'off');
        set(handles.glneighbors, 'value', 1);
    end

  case 3
    switch get(handles.method, 'value')
      case 1
        set(handles.glneighbors, 'enable', 'off');
      case 2
        set(handles.glneighbors, 'enable', 'off');
        set(handles.glneighbors, 'value', 2);
      case 3
        set(handles.glneighbors, 'enable', 'off');
        set(handles.glneighbors, 'value', 1);
    end

end


% --- Executes during object creation, after setting all properties.
function pruning_CreateFcn(hObject, eventdata, handles)
% hObject    handle to pruning (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in rounds.
function rounds_Callback(hObject, eventdata, handles)
% hObject    handle to rounds (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns rounds contents as cell array
%        contents{get(hObject,'Value')} returns selected item from rounds


% --- Executes during object creation, after setting all properties.
function rounds_CreateFcn(hObject, eventdata, handles)
% hObject    handle to rounds (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in method.
function method_Callback(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns method contents as cell array
%        contents{get(hObject,'Value')} returns selected item from method

contents = get(hObject, 'string');

switch cell2mat(contents(get(hObject,'value'),:))
  case 'Linear'
    if get(handles.pruning, 'value') == 3
      set(handles.pruning, 'value', 1);
    end
    set(handles.pruning, 'string', ...
      mat2cell(['Continuous    ';'Global Pruning'], [1 1]));

    if get(handles.sampling, 'value') > 3
      set(handles.sampling, 'value', 1);
    end
    set(handles.sampling, 'enable', 'on');
    set(handles.sampling, 'string', ...
      mat2cell(['Bootstrap    ';'Bootstrap 632';'Leave-one-out'], [1 1 1]));

    set(handles.neighbors, 'enable', 'off');
    set(handles.glneighbors, 'enable', 'off');

  case 'Lazy Learning'
    set(handles.pruning, 'string', ...
      mat2cell(['Continuous    ';'Global Pruning';'Local Pruning '], [1 1 1]));
    set(handles.sampling, 'value', 3);
    set(handles.sampling, 'enable', 'off');
    set(handles.rounds, 'enable', 'off');
    set(handles.neighbors, 'enable', 'on');
    if get(handles.pruning, 'value') == 3;
      set(handles.glneighbors, 'enable', 'off');
      set(handles.glneighbors, 'value', 2);
    else
      set(handles.glneighbors, 'enable', 'on');
    end

  case 'k-NN'
    if get(handles.pruning, 'value') == 3
      set(handles.pruning, 'value', 2);
    end
    set(handles.pruning, 'string', ...
      mat2cell(['Exhaustive    ';'Global Pruning'], [1 1]));
    
    set(handles.sampling, 'enable', 'on');
    set(handles.sampling, 'string', ...
      mat2cell(['Bootstrap     ';'Bootstrap 632 ';'Leave-one-out ';'LOO & Boot 632'], [1 1 1 1]));
    
    set(handles.neighbors, 'enable', 'on');
    set(handles.glneighbors, 'enable', 'off');
    set(handles.glneighbors, 'value', 1);

end


% --- Executes during object creation, after setting all properties.
function method_CreateFcn(hObject, eventdata, handles)
% hObject    handle to method (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in neighbors.
function neighbors_Callback(hObject, eventdata, handles)
% hObject    handle to neighbors (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns neighbors contents as cell array
%        contents{get(hObject,'Value')} returns selected item from neighbors


% --- Executes during object creation, after setting all properties.
function neighbors_CreateFcn(hObject, eventdata, handles)
% hObject    handle to neighbors (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes during object creation, after setting all properties.
function sampling_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sampling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

%%

% --- Executes during object creation, after setting all properties.
function glneighbors_CreateFcn(hObject, eventdata, handles)
% hObject    handle to glneighbors (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end




% --- Executes on selection change in sampling.
function sampling_Callback(hObject, eventdata, handles)
% hObject    handle to sampling (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns sampling contents as cell array
%        contents{get(hObject,'Value')} returns selected item from sampling

switch get(hObject,'value')
  case 1
    set(handles.rounds, 'enable', 'on');

  case 2
    set(handles.rounds, 'enable', 'on');

  case 3
    set(handles.rounds, 'enable', 'off');
    
  case 4
    set(handles.rounds, 'enable', 'on');

end


% --- Executes on button press in learn.
function learn_Callback(hObject, eventdata, handles)
% hObject    handle to learn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of learn

working('off', handles);
set(handles.time, 'string', '');
set(handles.step, 'string', '');
set(handles.selreg, 'string', '');
set(handles.selneigh, 'string', '');
set(handles.errortype, 'string', 'Validation MSE:');
set(handles.MSE, 'string', '');

data = get(handles.data,'string');
if isempty(data)
  uiwait(errordlg('No data specified or bad data!', 'Missing data!'));
  working('on', handles);
  return;
end

if strcmp(data, 'Loaded Data')
  data = get(handles.data, 'userdata');
else
  try
    data = load(data);
  catch
    uiwait(errordlg('No data specified or bad data!', 'Missing data!'));
    working('on', handles);
    return;
  end
end

if isstruct(data)
  names = fieldnames(data);
  data = data.(cell2mat(names(1)));
end

if size(data,1) > size(data,2)
  data = data';
end

if get(handles.predmethod, 'value') == 1
  steps = 1;
else
  steps = get(handles.steps, 'string');
  steps = str2num(cell2mat(steps(get(handles.steps, 'value'))));
end

regressor = get(handles.regressor, 'string');
regressor = str2num(cell2mat(regressor(get(handles.regressor, 'value'))));

neighbors = get(handles.neighbors, 'string');
neighbors = str2num(cell2mat(neighbors(get(handles.neighbors, 'value'))));

gl = get(handles.glneighbors, 'string');
gl = cell2mat(gl(get(handles.glneighbors, 'value')));

sampling = get(handles.sampling, 'value');

rounds = get(handles.rounds, 'string');
rounds = str2num(cell2mat(rounds(get(handles.rounds, 'value'))));

%% Learning according to selected methods
for i = 1:steps
  if steps > 1
    set(handles.step, 'string', ['Step ' num2str(i) ' of ' num2str(steps)]);
  else
    set(handles.step, 'string', '');
  end

  switch get(handles.method, 'value');
    case 1
      if get(handles.pruning, 'value') == 1
        [error, inputs] = Linear(data, regressor, i, sampling, rounds, ...
          handles.time);
      else
        [error, inputs] = LinearPrune(data, regressor, i, sampling, ...
          rounds, handles.time);
      end

    case 2
      switch get(handles.pruning, 'value')
        case 1
          [error, inputs, knn] = LL(data, regressor, neighbors, gl, i, ...
            sampling, rounds, handles.time);
        case 2
          [error, inputs, knn] = LLPrune(data, regressor, gl, neighbors, i, ...
            sampling, rounds, handles.time);
        case 3
          error = inf;
          inputs = [];
          working('on', handles);
          return;
      end

    case 3
      switch get(handles.pruning, 'value')
        case 1
          [error, inputs, knn] = KNN(data, regressor, neighbors, i, ...
            sampling, rounds, handles.time);
          
          if sampling == 4
            [error, knn] = KNNSingle(data, inputs(1,:), neighbors, i, ...
              2, rounds, handles.time);
          end

        case 2
          [error, inputs, knn] = KNNPrune(data, regressor, neighbors, ...
            i, sampling, rounds, handles.time)
          
          if sampling == 4
            [error, knn] = KNNSingle(data, inputs, neighbors, i, ...
              2, rounds, handles.time);
          end

      end

  end
  
%% Final part of learning
  figure(1); clf;
  plot(error);

  inputs = inputs(1,find(inputs(1,:) > 0));
  set(handles.selreg, 'string', num2str(inputs));
  allinputs(i, 1:length(inputs)) = inputs;

  if strcmp(gl, 'Global')
    set(handles.selneigh, 'string', num2str(knn(1,1)));
    allneighs(i, 1) = knn(1,1);
  end

  set(handles.MSE, 'string', num2str(min(error(1,:))));
  allerrors(i,1) = min(error(1,:));

  save DO_NOT_DELETE.mat data all* sampling rounds ...
    neighbors regressor steps;
end

working('on', handles);


% --- Executes on button press in predict.
function predict_Callback(hObject, eventdata, handles)
% hObject    handle to predict (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of predict

working('off', handles);
set(handles.time, 'string', '');
set(handles.step, 'string', '');
set(handles.selreg, 'string', '');
set(handles.selneigh, 'string', '');
set(handles.errortype, 'string', 'Prediction MSE:');
set(handles.MSE, 'string', '');
set(handles.predict, 'userdata', '');
set(handles.saveresults, 'userdata', '');

data = get(handles.data, 'string');
if isempty(data)
  uiwait(errordlg('No data specified or data empty!', 'No data'));
  working('on', handles);
  return;
elseif strcmp(data, 'Loaded Data')
  data = get(handles.data, 'userdata');
else
  try
    data = load(data);
  catch
    uiwait(errordlg('No data specified or bad data!', 'Missing data!'));
    working('on', handles);
    return;
  end
end

if isstruct(data)
  names = fieldnames(data);
  data = data.(cell2mat(names(1)));
end

if size(data,1) > size(data,2)
  data = data';
end

try
  load DO_NOT_DELETE.mat all*;
catch
  if get(handles.pruning, 'value') ~= 3
    uiwait(errordlg('Selected settings require learning!', ...
      'Missing Settings!'));
    working('on', handles);
    return;
  end
end

steps = get(handles.steps, 'string');
steps = str2num(cell2mat(steps(get(handles.steps, 'value'))));

gl = get(handles.glneighbors, 'string');
gl = cell2mat(gl(get(handles.glneighbors, 'value')));

%% If prediction type is Recursive
if get(handles.predmethod, 'value') == 1
  if get(handles.pruning, 'value') == 3
    regressor = get(handles.regressor, 'string');
    regressor = str2num(cell2mat(regressor(get(handles.regressor, 'value'))));
  else
    try 
      regressor = allinputs(1,:);
      maxreg = max(regressor);
      regressor(find(regressor == 0)) = [];
      set(handles.selreg, 'string', num2str(regressor));
    catch
      uiwait(errordlg('Cannot find selected inputs!', ...
        'Missing Settings!'));
      working('on', handles);
      return;
    end
  end

  switch gl
    case 'Local'
      neighbors = get(handles.neighbors, 'string');
      neighbors = str2num(cell2mat(neighbors(get(handles.neighbors, 'value'))));
    case 'Global'
      try
        neighbors = allneighs(1,1);
        set(handles.selneigh, 'string', num2str(neighbors));
      catch
        uiwait(errordlg('Cannot find selected number of global neighbors!', ...
          'Missing Settings!'));
        working('on', handles);
        return;
      end
  end

  switch get(handles.method, 'value');
    case 1
      if get(handles.pruning, 'value') == 1
        pred = Predict(data, maxreg, steps, 'lin');
      else
        pred = Predict(data, maxreg, steps, 'linprune', regressor);
      end

    case 2
      switch get(handles.pruning, 'value')
        case 1
          pred = Predict(data, maxreg, steps, 'llloo', gl, neighbors);
        case 2
          pred = Predict(data, maxreg, steps, 'llprune', gl, neighbors, ...
            regressor);
        case 3
          pred = PredictPLL(data, data(end-regressor+1:end), neighbors, ...
            steps, 'Recursive', handles.step);
      end

    case 3
      pred = PredictKNN(data, regressor, steps, 'recursive', neighbors);
  end

%% If prediction type is Direct
else
  if get(handles.pruning, 'value') ~= 3 & steps > size(allinputs,1)
    answer = questdlg(['Learning is properly done on ly up to step ' ...
      num2str(size(allinputs,1)) '. Do you want to use Direct method ' ...
      'with the regressor from the first timestep in all steps or ' ...
      'decrease the number of steps according to learning?'], ...
      'Inadequate Learning', 'First step', 'Decrease steps', 'Cancel', ...
      'First step');

    switch answer
      case 'First step'
        allinputs = ones(steps,1) * allinputs(1,:);
        if exist('allneighs')
          allneighs = ones(steps,1) * allneighs(1,1);
        end
      case 'Decrease steps'
        steps = size(allinputs,1);
      case 'Cancel'
        working('on', handles);
        return;
    end
  end
  
  switch gl
    case 'Local'
      neighbors = get(handles.neighbors, 'string');
      neighbors = str2num(cell2mat(neighbors(get(handles.neighbors, ...
        'value'))));
    case 'Global'
      neighbors = allneighs;
  end

  switch get(handles.method, 'value');
    case 1
      if get(handles.pruning, 'value') == 1
        pred = PredictDirect(data, allinputs, steps, 'lin');
      else
        pred = PredictDirect(data, allinputs, steps, 'linprune');
      end

    case 2
      switch get(handles.pruning, 'value')
        case 1
          pred = PredictDirect(data, allinputs, steps, 'llloo', gl, ...
            neighbors);
        case 2
          pred = PredictDirect(data, allinputs, steps, 'llprune', gl, ...
            neighbors);
        case 3
          regressor = get(handles.regressor, 'string');
          regressor = str2num(cell2mat(regressor(get(handles.regressor, ...
            'value'))));

          pred = PredictPLL(data, data(end-regressor+1:end), neighbors, ...
            steps, 'Direct', handles.step);
      end

    case 3
      pred = PredictKNN(data, allinputs, steps, 'direct', neighbors);

  end
end
%% Final part of Prediction
figure(2); clf;
plot(pred);
title('Prediction');
xlabel('Timesteps');

set(handles.saveresults, 'userdata', pred);

real = get(handles.realvalues, 'string');
if ~isempty(real)
  if strcmp(real, 'Loaded Data')
    real = get(handles.realvalues, 'userdata');
  else
    try
      real = load(real);
    catch
      uiwait(errordlg('Real values contain bad data!', 'Bad data!'));
      working('on', handles);
      return;
    end
  end

  if isstruct(real)
    names = fieldnames(real);
    real = real.(cell2mat(names(1)));
  end

  if size(real,1) > size(real,2)
    real = real';
  end

  figure(2); hold on;
  if length(pred) < length(real)
    plot(real(1:length(pred)), 'r');
    mse = mean((real(1:length(pred)) - pred).^2);
  else
    plot(real, 'r');
    mse = mean((real - pred(1:length(real))).^2);
  end

  title('Prediction in Blue and Real values in Red');
  xlabel(['Timesteps, Real prediction MSE ' num2str(mse)]);
  set(handles.MSE, 'string', num2str(mse));
  set(handles.predict, 'userdata', mse);
end

working('on', handles);


% --- Executes on selection change in regressor.
function regressor_Callback(hObject, eventdata, handles)
% hObject    handle to regressor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns regressor contents as cell array
%        contents{get(hObject,'Value')} returns selected item from regressor


% --- Executes during object creation, after setting all properties.
function regressor_CreateFcn(hObject, eventdata, handles)
% hObject    handle to regressor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in predmethod.
function predmethod_Callback(hObject, eventdata, handles)
% hObject    handle to predmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns predmethod contents as cell array
%        contents{get(hObject,'Value')} returns selected item from predmethod


% --- Executes during object creation, after setting all properties.
function predmethod_CreateFcn(hObject, eventdata, handles)
% hObject    handle to predmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in steps.
function steps_Callback(hObject, eventdata, handles)
% hObject    handle to steps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns steps contents as cell array
%        contents{get(hObject,'Value')} returns selected item from steps


% --- Executes during object creation, after setting all properties.
function steps_CreateFcn(hObject, eventdata, handles)
% hObject    handle to steps (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc
  set(hObject,'BackgroundColor','white');
else
  set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end


% --- Executes on selection change in glneighbors.
function glneighbors_Callback(hObject, eventdata, handles)
% hObject    handle to glneighbors (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns glneighbors contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        glneighbors


% --- Executes on button press in loadsetting.
function loadsetting_Callback(hObject, eventdata, handles)
% hObject    handle to loadsetting (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[loadfile, loadpath] = uigetfile('*.mat', 'Load Settings');
if isequal(loadfile, 0) | isequal(loadpath, 0)
  return;
end

load([loadpath loadfile], 'data', 'real', 'testset', 'all*', 'method', ...
  'pruning', 'neighbors', 'glneighbors', 'sampling', ...
  'rounds', 'regressor', 'predmethod', 'steps');

try
  save DO_NOT_DELETE.mat all*;

  if isempty(data)
    set(handles.data, 'string', '');
    set(handles.data, 'userdata', '');
  else
    set(handles.data, 'string', 'Loaded Data');
    set(handles.data, 'userdata', data);
  end

  if isempty(real)
    set(handles.realvalues, 'string', '');
    set(handles.realvalues, 'userdata', '');
  else
    set(handles.realvalues, 'string', 'Loaded Data');
    set(handles.realvalues, 'userdata', real);
  end

  if exist('testset') & ~isempty(testset)
    set(handles.testset, 'string', 'Loaded Data');
    set(handles.testset, 'userdata', testset);
  else
    set(handles.testset, 'string', '');
    set(handles.testset, 'userdata', '');
  end

  temp = get(handles.method, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    if strcmp(method, temp(i,:))
      set(handles.method, 'value', i);
      method_Callback(handles.method, eventdata, handles);
    end
  end

  temp = get(handles.pruning, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(pruning, temp(i,:));
    if strcmp(pruning, temp(i,:))
      set(handles.pruning, 'value', i);
      pruning_Callback(handles.pruning, eventdata, handles);
    end
  end

  temp = get(handles.neighbors, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(neighbors, temp(i,:));
    if strcmp(neighbors, temp(i,:))
      set(handles.neighbors, 'value', i);
      neighbors_Callback(handles.neighbors, eventdata, handles);
    end
  end

  temp = get(handles.glneighbors, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(glneighbors, temp(i,:));
    if strcmp(glneighbors, temp(i,:))
      set(handles.glneighbors, 'value', i);
      glneighbors_Callback(handles.glneighbors, eventdata, handles);
    end
  end

  temp = get(handles.sampling, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(sampling, temp(i,:));
    if strcmp(sampling, temp(i,:))
      set(handles.sampling, 'value', i);
      sampling_Callback(handles.sampling, eventdata, handles);
    end
  end

  temp = get(handles.rounds, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(rounds, temp(i,:));
    if strcmp(rounds, temp(i,:))
      set(handles.rounds, 'value', i);
      rounds_Callback(handles.rounds, eventdata, handles);
    end
  end

  temp = get(handles.regressor, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(regressor, temp(i,:));
    if strcmp(regressor, temp(i,:))
      set(handles.regressor, 'value', i);
      regressor_Callback(handles.regressor, eventdata, handles);
    end
  end

  temp = get(handles.predmethod, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(predmethod, temp(i,:));
    if strcmp(predmethod, temp(i,:))
      set(handles.predmethod, 'value', i);
      predmethod_Callback(handles.predmethod, eventdata, handles);
    end
  end

  temp = get(handles.steps, 'string');
  [rows, columns] = size(temp);
  for i = 1:rows
    strcmp(steps, temp(i,:));
    if strcmp(steps, temp(i,:))
      set(handles.steps, 'value', i);
      steps_Callback(handles.steps, eventdata, handles);
    end
  end

catch
  uiwait(errordlg('Selected file is not a valid Settings file!', ...
    'Wrong file format!'));
  return;
end


% --- Executes on button press in savesetting.
function savesetting_Callback(hObject, eventdata, handles)
% hObject    handle to savesetting (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

try
  load DO_NOT_DELETE.mat all*;
catch
  allinputs = [];
  allerrors = [];
  allneighs = [];
end

temp = get(handles.data,'string');
if isempty(temp)
  data = [];
else
  if strcmp(temp, 'Loaded Data')
    data = get(handles.data, 'userdata');
  else
    try
      data = load(temp);
    catch
      uiwait(errordlg('No data specified or bad data!', 'Missing data!'));
      working('on', handles);
      return;
    end
  end

  if isstruct(data)
    names = fieldnames(data);
    data = data.(cell2mat(names(1)));
  end

  if size(data,1) > size(data,2)
    data = data';
  end
end

real = get(handles.realvalues, 'string');
if isempty(real)
  real = [];

elseif strcmp(real, 'Loaded Data');
  real = get(handles.realvalues, 'userdata');

else
  try
    real = load(real);
  catch
    uiwait(errordlg('Real values contain bad data!', 'Bad data!'));
    working('on', handles);
    return;
  end


  if isstruct(real)
    names = fieldnames(real);
    real = real.(cell2mat(names(1)));
  end

  if size(real,1) > size(real,2)
    real = real';
  end
end

testset = get(handles.testset, 'string');
if isempty(testset)
  testset = [];
elseif strcmp(testset, 'Loaded Data')
  testset = get(handles.testset, 'userdata');
else
  try
    testset = load(testset);
  catch
    uiwait(errordlg('Test set contains bad data!', 'Bad test set!'));
    working('on', handles);
    return;
  end
end

if isstruct(testset)
  names = fieldnames(testset);
  testset = testset.(cell2mat(names(1)));
end

if size(testset,1) > size(testset,2)
  testset = testset';
end

method = get(handles.method, 'string');
method = cell2mat(method(get(handles.method, 'value')));

pruning = get(handles.pruning, 'string');
pruning = cell2mat(pruning(get(handles.pruning, 'value')));

sampling = get(handles.sampling, 'string');
sampling = cell2mat(sampling(get(handles.sampling, 'value')));

rounds = get(handles.rounds, 'string');
rounds = cell2mat(rounds(get(handles.rounds, 'value')));

neighbors = get(handles.neighbors, 'string');
neighbors = cell2mat(neighbors(get(handles.neighbors, 'value')));

glneighbors = get(handles.glneighbors, 'string');
glneighbors = cell2mat(glneighbors(get(handles.glneighbors, 'value')));

regressor = get(handles.regressor, 'string');
regressor = cell2mat(regressor(get(handles.regressor, 'value')));

predmethod = get(handles.predmethod, 'string');
predmethod = cell2mat(predmethod(get(handles.predmethod, 'value')));

steps = get(handles.steps, 'string');
steps = cell2mat(steps(get(handles.steps, 'value')));

[savefile, savepath] = uiputfile('*.mat', 'Save Settings');
if isequal(savefile, 0) | isequal(savepath, 0)
  return;
end

save([savepath savefile], 'data', 'real', 'testset', 'all*', 'method', ...
  'pruning', 'neighbors', 'glneighbors', 'sampling', ...
  'rounds', 'regressor', 'predmethod', 'steps');


% --- Executes on button press in saveresults.
function saveresults_Callback(hObject, eventdata, handles)
% hObject    handle to saveresults (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[savefile, savepath] = uiputfile('*.mat', 'Save Results');
if isequal(savefile, 0) | isequal(savepath, 0)
  return;
end

pred = get(handles.saveresults, 'userdata');
predmse = get(handles.predict, 'userdata');
testmse = get(handles.testerror, 'userdata');

save([savepath savefile], 'pred', '*mse');


% --- Executes during object deletion, before destroying properties.
function lazy_DeleteFcn(hObject, eventdata, handles)
% hObject    handle to lazy (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

try
  warning off;
  delete DO_NOT_DELETE.mat;
catch
  return;
end


%% Test error calculation
% --- Executes on button press in testerror.
function testerror_Callback(hObject, eventdata, handles)
% hObject    handle to testerror (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

working('off', handles);
set(handles.testerror, 'userdata', '');
set(handles.selreg, 'string', '');
set(handles.selneigh, 'string', '');

data = get(handles.data, 'string');
if isempty(data)
  uiwait(errordlg('No data specified or data empty!', 'No data'));
  working('on', handles);
  return;
elseif strcmp(data, 'Loaded Data')
  data = get(handles.data, 'userdata');
else
  try
    data = load(data);
  catch
    uiwait(errordlg('No data specified or bad data!', 'Missing data!'));
    working('on', handles);
    return;
  end
end

if isstruct(data)
  names = fieldnames(data);
  data = data.(cell2mat(names(1)));
end

if size(data,1) > size(data,2)
  data = data';
end

testset = get(handles.testset, 'string');
if isempty(testset)
  uiwait(errordlg('No test set specified!', 'No testset!'));
  working('on', handles);
  return;
elseif strcmp(testset, 'Loaded Data')
  testset = get(handles.testset, 'userdata');
else
  try
    testset = load(testset);
  catch
    uiwait(errordlg('Test set contains bad data!', 'Bad test set!'));
    working('on', handles);
    return;
  end
end

if isstruct(testset)
  names = fieldnames(testset);
  testset = testset.(cell2mat(names(1)));
end

if size(testset,1) > size(testset,2)
  testset = testset';
end

try
  load DO_NOT_DELETE.mat all*;
catch
  if get(handles.pruning, 'value') ~= 3
    uiwait(errordlg('Selected settings require learning!', ...
      'Missing Settings!'));
    working('on', handles);
    return;
  end
end

steps = get(handles.steps, 'string');
steps = str2num(cell2mat(steps(get(handles.steps, 'value'))));

gl = get(handles.glneighbors, 'string');
gl = cell2mat(gl(get(handles.glneighbors, 'value')));

%% If testing type is Recursive
if get(handles.predmethod, 'value') == 1
  if get(handles.pruning, 'value') == 3
    reg = get(handles.regressor, 'string');
    reg = str2num(cell2mat(reg(get(handles.regressor, 'value'))));
    maxreg = reg;
  else
    try
      reg = allinputs(1,:);
      maxreg = max(reg);
      reg(find(reg == 0)) = [];
      set(handles.selreg, 'string', num2str(reg));
      reg = ones(1, length(reg)) * (maxreg+1) - reg;
    catch
      uiwait(errordlg('Cannot find previously selected inputs!', ...
        'Missing Settings!'));
      working('on', handles);
      return;
    end
  end

  switch gl
    case 'Local'
      neighbors = get(handles.neighbors, 'string');
      neighbors = str2num(cell2mat(neighbors(get(handles.neighbors, 'value'))));
    case 'Global'
      try
        neighbors = allneighs(1,1);
        set(handles.selneigh, 'string', num2str(neighbors));
      catch
        uiwait(errordlg('Cannot find learned values for global neighbors!', ...
          'Missing Settings!'));
        working('on', handles);
        return;
      end
  end

  [xl, yl] = regressor2(data, maxreg);
  [rowsl, columnsl] = size(xl);
  
  [xt, yt] = regressor2(testset, maxreg, steps, 'nobias');
  [rowst, columnst] = size(xt);

  pred = [];
  
  switch get(handles.method, 'value');
    case 1
      % Linear Continuous
      if get(handles.pruning, 'value') == 1
        beta = xl\yl;

        for i = 1:steps
          xq = [xt(:,i:end) pred];
          xq = [xq(:,end-maxreg+1:end) ones(rowst,1)];
          pred = [pred xq * beta];
        end
          
        % Linear Pruned
      else
        xl = xl(:, [reg end]);
        beta = xl\yl;

        for i = 1:steps
          xq = [xt(:,i:end) pred];
          xq = xq(:,end-maxreg+1:end);
          xq = [xq(:,reg) ones(rowst,1)];
          pred = [pred xq * beta];
        end
      end

    case 2
      switch get(handles.pruning, 'value')
        % Lazy Learning Continuous
        case 1
          for i = 1:steps
            set(handles.step, 'string', ...
              ['Step ' num2str(i) ' of ' num2str(steps)]);
            drawnow;
              
            xq = [xt(:,i:end) pred];
            xq = [xq(:,end-maxreg+1:end) ones(rowst,1)];

            temp = ones(rowst,1) * inf;

            switch gl
              case 'Local'
                for r = 1:rowst
                  beta = Neighborhood(xq(r,:), xl, yl, ...
                    size(xq,2), neighbors);
                  temp(r) = xq(r,:) * beta';
                end
              case 'Global'
                for r = 1:rowst
                  [Sorted, I] = ...
                    sort(mean((ones(rowsl,1) * xq(r,:) - xl) .^ 2, 2));
                  beta = xl(I(1:neighbors),:)\yl(I(1:neighbors));
                  temp(r) = xq(r,:) * beta;
                end
            end

            pred = [pred temp];
          end

          % Lazy Learning Global Pruning
        case 2
          xl = xl(:, [reg end]);

          for i = 1:steps
            set(handles.step, 'string', ...
              ['Step ' num2str(i) ' of ' num2str(steps)]);
            drawnow;
              
            xq = [xt(:,i:end) pred];
            xq = xq(:,end-maxreg+1:end);
            xq = [xq(:,reg) ones(rowst,1)];

            temp = ones(rowst,1) * inf;

            switch gl
              case 'Local'
                for r = 1:rowst
                  beta = Neighborhood(xq(r,:), xl, yl, ...
                    size(xq,2), neighbors);
                  temp(r) = xq(r,:) * beta';
                end
              case 'Global'
                for r = 1:rowst
                  [Sorted, I] = ...
                    sort(mean((ones(rowsl,1) * xq(r,:) - xl) .^ 2, 2));
                  beta = xl(I(1:neighbors),:)\yl(I(1:neighbors));
                  temp(r) = xq(r,:) * beta;
                end
            end

            pred = [pred temp];
          end

          % Lazy Learning Local Pruning
        case 3
          pred = ones(rowst,steps) * inf;

          for r = 1:rowst
            set(handles.time, 'string', ['Test rounds done: ' ...
              num2str(r) ' out of ' num2str(rowst)]);
            drawnow;
            
            pred(r,:) = PredictPLL(data, xt(r,:), neighbors, steps, ...
              'Recursive', handles.step);

            testerrorsofar = mean((pred(1:r,:) - yt(1:r,:)) .^2 , 1)
          end
      end

      % K-NN
    case 3
      xl(:,end) = [];
      xl = xl(:, reg);

      for i = 1:steps
        xq = [xt(:,i:end) pred];
        xq = xq(:,end-maxreg+1:end);
        xq = xq(:,reg);
        
        temp = ones(rowst,1) * inf;
        
        for r = 1:rowst
          [Sorted, I] = sort(sum((ones(rowsl,1) * xq(r,:) - xl) .^ 2, 2));
          temp(r) = mean(yl(I(1:neighbors)));
        end
        
        pred = [pred temp];
      end

  end

  testerror = mean((pred - yt) .^2 , 1);

%% If testing type is Direct
else
  if get(handles.pruning, 'value') == 3
    maxreg = get(handles.regressor, 'string');
    maxreg = str2num(cell2mat(maxreg(get(handles.regressor, 'value'))));
  else
    if steps > size(allinputs,1)
      answer = questdlg(['Learning is properly done on ly up to step ' ...
        num2str(size(allinputs,1)) '. Do you want to use Direct method with ' ...
        'the regressor from the first timestep in all steps or decrease the ' ...
        'number of steps according to learning?'], 'Inadequate Learning', ...
        'First step', 'Decrease steps', 'Cancel', 'First step');

      switch answer
        case 'First step'
          allinputs = ones(steps,1) * allinputs(1,:);
          if exist('allneighs')
            allneighs = ones(steps,1) * allneighs(1,1);
          end
        case 'Decrease steps'
          steps = size(allinputs,1);
        case 'Cancel'
          working('on', handles);
          return;
      end
    end
    
    maxreg = max(max(allinputs, [], 2));
  end
  
  switch gl
    case 'Local'
      neighbors = get(handles.neighbors, 'string');
      neighbors = str2num(cell2mat(neighbors(get(handles.neighbors, 'value'))));
    case 'Global'
      neighbors = allneighs(:,1);
  end
  
  [xl, yl] = regressor2(data, maxreg, steps);
  [rowsl, columnsl] = size(xl);
  
  [xt, yt] = regressor2(testset, maxreg, steps, 'nobias');
  [rowst, columnst] = size(xt);

  pred = [];
  
  switch get(handles.method, 'value');
    case 1
      % Linear Continuous
      if get(handles.pruning, 'value') == 1
        for i = 1:steps
          index = max(allinputs(i,:));
          xq = [xt(:,end-index+1:end) ones(rowst,1)];

          beta = xl(:,end-index:end)\yl(:,i);
          pred = [pred xq * beta];
        end

        % Linear Pruning
      else
        for i = 1:steps
          index = allinputs(i,:);
          index(find(index == 0)) = [];
          index = ones(1,length(index)) * (maxreg+1) - index;

          xq = xt(:,end-maxreg+1:end);
          xq = [xq(:,index) ones(rowst,1)];

          beta = xl(:, [index end])\yl(:,i);
          pred = [pred xq * beta];
        end
      end

    case 2
      switch get(handles.pruning, 'value')
        % Lazy Learning Continuous
        case 1
          for i = 1:steps
            set(handles.step, 'string', ...
              ['Step ' num2str(i) ' of ' num2str(steps)]);
            drawnow;

            index = max(allinputs(i,:));
            xq = [xt(:,end-index+1:end) ones(rowst,1)];

            xl2 = xl(:,end-index:end);

            temp = ones(rowst,1) * inf;

            switch gl
              case 'Local'
                for r = 1:rowst
                  beta = Neighborhood(xq(r,:), xl2, yl(:,i), ...
                    size(xq,2), neighbors);
                  temp(r) = xq(r,:) * beta';
                end
              case 'Global'
                for r = 1:rowst
                  [Sorted, I] = ...
                    sort(mean((ones(rowsl,1) * xq(r,:) - xl2) .^ 2, 2));
                  beta = xl2(I(1:neighbors(i)),:)\yl(I(1:neighbors(i)),i);
                  temp(r) = xq(r,:) * beta;
                end
            end

            pred = [pred temp];
          end

          % Lazy Learning Global Pruning
        case 2
          for i = 1:steps
            set(handles.step, 'string', ...
              ['Step ' num2str(i) ' of ' num2str(steps)]);
            drawnow;

            index = allinputs(i,:);
            index(find(index == 0)) = [];
            index = ones(1,length(index)) * (maxreg+1) - index;

            xq = [xt(:,index) ones(rowst,1)];
            xl2 = xl(:, [index end]);

            temp = ones(rowst,1) * inf;

            switch gl
              case 'Local'
                for r = 1:rowst
                  beta = Neighborhood(xq(r,:), xl2, yl(:,i), ...
                    size(xq,2), neighbors);
                  temp(r) = xq(r,:) * beta';
                end
              case 'Global'
                for r = 1:rowst
                  [Sorted, I] = ...
                    sort(mean((ones(rowsl,1) * xq(r,:) - xl2) .^ 2, 2));
                  beta = xl2(I(1:neighbors(i)),:)\yl(I(1:neighbors(i)),i);
                  temp(r) = xq(r,:) * beta;
                end
            end

            pred = [pred temp];
          end

          % Lazy Learning Local Pruning
        case 3
          pred = ones(rowst,steps) * inf;

          for r = 1:rowst
            set(handles.time, 'string', ['Test rounds done: ' ...
              num2str(r) ' out of ' num2str(rowst)]);
            drawnow;
            
            pred(r,:) = PredictPLL(data, xt(r,:), neighbors, steps, ...
              'Direct', handles.step);

            testerrorsofar = mean((pred(1:r,:) - yt(1:r,:)) .^2 , 1)
          end

      end

      % K-NN
    case 3
      for i = 1:steps
        index = allinputs(i,:);
        index(find(index == 0)) = [];
        index = ones(1,length(index)) * (maxreg+1) - index;

        xq = xt(:, index);
        xl2 = xl(:, index);

        temp = ones(rowst,1) * inf;
        
        for r = 1:rowst
          [Sorted, I] = sort(sum((ones(rowsl,1) * xq(r,:) - xl2) .^ 2, 2));
          temp(r) = mean(yl(I(1:neighbors(i)),i));
        end
        
        pred = [pred temp];
      end
      
  end
  
  testerror = mean((pred - yt) .^2 , 1);

end

set(handles.errortype, 'string', 'Test MSE:');
set(handles.MSE, 'string', num2str(mean(testerror)));
set(handles.testerror, 'userdata', testerror);

figure(3); clf;
plot(testerror);
title('Testerror according to steps');
xlabel(['Mean testerror over all steps: ' num2str(mean(testerror))]);
working('on', handles);


% --- Executes on button press in testsetbrowse.
function testsetbrowse_Callback(hObject, eventdata, handles)
% hObject    handle to testsetbrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

inidir = pwd;
testdir = get(handles.testset, 'string');

try
  [pathstr] = fileparts(testdir);
  cd(pathstr);
catch
  % Nothing here...
end

[loadfile, loadpath] = uigetfile('*.*', 'Load Test Data');


if ~isequal(loadfile, 0) & ~isequal(loadpath, 0)
  set(handles.testset, 'string', [loadpath loadfile]);
end

cd(inidir);

