function [BETA, NEIGH, ERROR] = Neighborhood(xq, x, y, MinNN, MaxNN, varargin)

[s1, s2] = size(x);

dist = mean((ones(s1,1) * xq - x) .^ 2, 2);
[II1,II2]=sort(dist);

NN=2;
dkk2=2;
while dkk2<MinNN+2 & NN < MaxNN-1
  if II1(NN)~=II1(NN-1)
    dkk2=dkk2+1;
  end
  NN=NN+1;
end

ERR(1:NN)=inf;

XX2=x(II2(1:NN),:);
YY2=y(II2(1:NN),:);

for i=1:NN
  XX3=XX2([1:i-1 i+1:NN],:);
  YY3=YY2([1:i-1 i+1:NN],1);
  beta=XX3\YY3;
  YYih=XX2(i,:)*beta;
  err(i)=(YY2(i,1)-YYih).^2;
end

ERR(NN)=mean(err);
clear err;

P = inv(XX2'*XX2);
beta = XX2\YY2;

for r = NN+1:MaxNN
  P2 = P - (P*x(II2(r),:)'*x(II2(r),:)*P) / (1+x(II2(r),:)*P*x(II2(r),:)');
  R = P2*x(II2(r),:)';
  e = y(II2(r)) - x(II2(r),:)*beta;
  beta2 = beta + R*e;
  
  for i = 1:r
    err(i) = ((y(II2(i)) - x(II2(i),:) * beta2) / (1 - x(II2(i),:)*P2*x(II2(i),:)'))^2;
  end
  
  ERR(r) = mean(err);
  if ERR(r) == inf
    r = r
    err = err
  end
  clear err;
  
  P = P2;
  beta = beta2;
end

if nargin == 6 & strcmp(varargin{1}, 'all')
  ERROR = ERR;
  NEIGH = 1:MaxNN;
  BETA = 0;
else
  [ERROR,NEIGH]=min(ERR);

  XX2=x(II2(1:NEIGH),:);
  YY2=y(II2(1:NEIGH),:);
  BETA=(XX2\YY2)';
end