function [error, inputs, knn] = ...
  KNN(data, reg, neigh, timestep, sampling, rounds, timehandle);

set(timehandle, 'string', 'Estimating calculation time...');
% For calculating the time needed
start = clock;
pempem = 1;

if sampling == 4
  method = 3;
else
  method = sampling;
end

% Making the regressor
[x, y] = regressor(data, reg, timestep, 'nobias');
[rows, columns] = size(x);

if method ~= 3
  bbb = round(rand(rows,rounds)*(rows-1))+1;
end

% Initializing result variables
error = ones(1,10)*inf;
knn = zeros(1,10);
bestreg = zeros(1,10);
drawnow;

% The main loop
for b = 1 : 2^reg-1
  xx = x(:, (dec2bin(b, reg)-48) == 1);

  switch method
    case 1
      % This is for Bootstrap
      dist = zeros(rows,rows);
      yappIh = zeros(rows,neigh);

      for i=1:rows
        d1=mean((xx-ones(rows,1)*xx(i,:)).^2,2);
        dist(:,i) = d1;
        [I1,I2]=sort(d1);
        temp = cumsum(y(I2(1:neigh)))';
        yappIh(i,:)=temp./(1:neigh);
      end

      errappI=mean((yappIh-(y*ones(1,neigh))).^2);

      errval = zeros(rounds,neigh);
      errapp = zeros(rounds,neigh);

      for iii=1:rounds
        yapp=y(bbb(:,iii),end);
        distboot = dist(bbb(:,iii),:);
        [I1,I2]=sort(distboot);
        temp = cumsum(yapp(I2(1:neigh,:)),1)';
        yvalh = temp./(ones(rows,1)*(1:neigh));
        errval(iii,:)=mean((yvalh-(y*ones(1,neigh))).^2);

        I2 = I2(:,bbb(:,iii));
        temp = cumsum(yapp(I2(1:neigh,:)),1)';
        yapph = temp./(ones(rows,1)*(1:neigh));
        errapp(iii,:)=mean((yapph-(yapp*ones(1,neigh))).^2);
      end

      Errors2 = mean(errval-errapp)+errappI;

      if mod(b,20) == 5
        left = floor((2^reg-pempem)*etime(clock,start)/pempem/60)+1;
        set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
        drawnow;
      end

    case 2
      % This is for Bootstrap 632
      dist = zeros(rows,rows);
      yh = zeros(rows,neigh);

      for i=1:rows
        d1=mean((xx-ones(rows,1)*xx(i,:)).^2,2);
        dist(:,i) = d1;
        [I1,I2]=sort(d1);
        temp=cumsum(y(I2(1:neigh)))';
        yh(i,:)=temp./(1:neigh);
      end

      errappI=mean((yh-(y*ones(1,neigh))).^2);

      errval = zeros(rounds,neigh);

      for iii=1:rounds
        yapp=y(bbb(:,iii),end);
        [ccc,ia] = setdiff((1:rows)',bbb(:,iii));

        yval=y(ccc,end);
        distboot = dist(bbb(:,iii),ccc);
        s2=size(yval,1);

        [I1,I2]=sort(distboot,1);
        temp = cumsum(yapp(I2(1:neigh,:)),1)';
        yvalh = temp./(ones(s2,1)*(1:neigh));

        errval(iii,:)=mean((yvalh-(yval*ones(1,neigh))).^2);
      end

      Errors2 = mean(errval)*0.632+errappI*(1-0.632);

      if mod(b,20) == 5
        left = floor((2^reg-pempem)*etime(clock,start)/pempem/60)+1;
        set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
        drawnow;
      end

    case 3
      % This is for Leave-One-Out
      Errors = ones(rows, neigh)*inf;

      for i = 1:rows
        xLoo = xx([1:i-1 i+1:rows],:);
        yLoo = y([1:i-1 i+1:rows]);

        [sorted, index] = sort(sum((ones(rows-1,1) * xx(i,:) ...
          - xLoo) .^ 2, 2));

        Errors(i,:) = ((cumsum(yLoo(index(1:neigh))')./(1:neigh)) - y(i)).^2;
      end

      Errors2 = mean(Errors, 1);

      if mod(b,300) == 30
        left = floor((2^reg-pempem)*etime(clock,start)/pempem/60)+1;
        set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
        drawnow;
      end

  end

  % Minimum global K
  [aa, bb] = min(Errors2, [], 2);

  % If tested regressor is better than some previous one, we save it
  if aa < error(end)
    error = [error aa];
    knn = [knn bb];
    bestreg = [bestreg b];

    [error, III] = sort(error);
    error = error(1:10);
    knn = knn(III(1:10));
    bestreg = bestreg(III(1:10));
  end

  pempem = pempem+1;
end

inputs = (dec2bin(bestreg,reg) - 48);
inputs = ones(size(inputs,1),1)*(size(inputs,2):-1:1) .* inputs;

left = round(etime(clock, start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);
