function prediction = Predict(data, reg, steps, method, varargin)

[rows, columns] = size(data);

if rows > columns
  data = data';
  [rows, columns] = size(data);
end

switch lower(method)
%% Linear Continuous
  case 'lin'
    if nargin ~= 4
      disp('Wrong number of arguments!');
      help Predict
      return;
    end

    % The regressor of appropriate size
    [x, y] = regressor(data, reg);

    % Solving
    beta = x\y;

    % Predicting
    for i = 1:steps
      xq = [data(columns-reg+i:columns+i-1) 1];

      pred = xq * beta;

      data = [data pred];
    end
    
%% Linear Pruning
  case 'linprune'
    if nargin ~= 5
      disp('Wrong number of arguments!');
      help Predict
      Prediction = 0;
      return;
    else
      index = varargin{1};
      regmax = max(index);
      index(find(index == 0)) = [];
      index = ones(1,length(index)) * (regmax+1) - index;
    end

    % The regressor of appropriate size
    [x, y] = regressor(data, regmax);

    % Taking only the right columns according to pruning
    x = x(:, [index end]);

    % Solving
    beta = x\y;

    % Predicting
    for i = 1:steps
      xq = data(columns-regmax+i:columns+i-1);
      xq = [xq(index) 1];
      pred = xq * beta;

      data = [data pred];
    end

%% Lazy Learning Continuous
  case 'llloo'
    Neighbors = varargin{2};

    % The regressor of appropriate size
    [x, y] = regressor(data, reg);
    rows = size(x,1);

    for i = 1:steps
      xq = [data(end-reg+1:end) 1];

      switch varargin{1}
        case 'Local'
          beta = Neighborhood(xq, x, y, size(x,2), Neighbors);
        case 'Global'
          dist = mean((ones(rows,1) * xq - x) .^ 2, 2);
          [Sorted, I] = sort(dist);
          
          beta = (x(I(1:Neighbors),:)\y(I(1:Neighbors)))';
      end
      
      pred = xq * beta';
      data = [data pred];
    end

%% Lazy Learning Pruning
  case 'llprune'
    Neighbors = varargin{2};
    index = varargin{3};
    
    maxreg = max(index);
    index(find(index == 0)) = [];
    index = ones(1,length(index)) * (maxreg+1) - index;

    % The regressor of appropriate size
    [x, y] = regressor(data, maxreg);
    rows = size(x,1);
    
    % Taking only the right columns according to pruning
    x = x(:, [index end]);

    for i = 1:steps
      xq = data(end-maxreg+1:end);
      xq = [xq(index) 1];
      
      switch varargin{1}
        case 'Local'
          beta = Neighborhood(xq, x, y, size(x,2), Neighbors);
        case 'Global'
          dist = mean((ones(rows,1) * xq - x) .^ 2, 2);
          [Sorted, I] = sort(dist);
          
          beta = (x(I(1:Neighbors),:)\y(I(1:Neighbors)))';
      end
      
      pred = xq * beta';
      data = [data pred];
    end

  otherwise
    disp('There is no such a method!');
    help Predict
    prediction = 0;
    return;
end

prediction = data(columns+1:columns+steps);