function prediction = PredictDirect(data, reg, steps, method, varargin)

[rows, columns] = size(data);

if rows > columns
  data = data';
  [rows, columns] = size(data);
end

if strcmp(method, 'scalesqrt')
  method = 'scale';
  sq = 1;
else
  sq = 0;
end

prediction = [];

switch lower(method)
%% Linear
  case 'lin'
    if nargin ~= 4
      disp('Wrong number of arguments!');
      help Predict
      return;
    end

    % Predicting
    for i = 1:steps
      maxreg = max(reg(i,:));
      xq = [data(end-maxreg+1:end) 1];

      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, i);

      % Solving
      beta = x\y;
      prediction = [prediction xq * beta];
    end
%% Linear Pruning
  case 'linprune'
    for i = 1:steps
      % Taking only the right columns according to pruning
      maxreg = max(reg(i,:));

      index = reg(i,:);
      index(find(index == 0)) = [];
      index = ones(1,length(index)) * (max(index)+1) - index;

      xq = data(end-maxreg+1:end);
      xq = [xq(index) 1];

      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, i);
      x = x(:,[index end]);

      % Solving
      beta = x\y;

      % Predicting
      prediction = [prediction xq * beta];
    end
%% Lazy Learning
  case 'llloo'
    neigh = varargin{2};

    for i = 1:steps
      maxreg = max(reg(i,:));
      xq = [data(end-maxreg+1:end) 1];
            
      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, i);
      rows = size(x,1);

      switch varargin{1}
        case 'Local'
          beta = Neighborhood(xq, x, y, size(x,2), neigh);
        case 'Global'
          Neighbors = neigh(i);

          dist = mean((ones(rows,1) * xq - x) .^ 2, 2);
          [Sorted, I] = sort(dist);
          beta = (x(I(1:Neighbors),:)\y(I(1:Neighbors)))';
      end

      prediction = [prediction xq * beta'];
    end
%% Lazy Learning Pruning
  case 'llprune'
    neigh = varargin{2};

    for i = 1:steps
      maxreg = max(reg(i,:));

      index = reg(i,:);
      index(find(index == 0)) = [];
      index = ones(1,length(index)) * (max(index)+1) - index;

      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, i);
      rows = size(x,1);

      % Taking only the right columns according to pruning
      x = x(:, [index end]);

      xq = data(end-maxreg+1:end);
      xq = [xq(index) 1];

      switch varargin{1}
        case 'Local'
          beta = Neighborhood(xq, x, y, size(x,2), neigh);
        case 'Global'
          Neighbors = neigh(i);
          
          dist = mean((ones(rows,1) * xq - x) .^ 2, 2);
          [Sorted, I] = sort(dist);
          beta = (x(I(1:Neighbors),:)\y(I(1:Neighbors)))';
      end

      prediction = [prediction xq * beta'];
    end

    
  case 'scale'
    xq = [data(columns-reg+1:columns) 1];

    switch nargin
      case 6
        % Previously calculated values must be in the right form
        beta1 = varargin{1};
        beta2 = varargin{2};

        for i = 1:steps
          % The regressor of appropriate size
          [x, y] = regressor(data, reg, i);
          rows = size(x,1);

          x2 = ones(size(x));

          dist = zeros(rows,1);

          for d = 1:rows
            dist(d) = sum((x(d,:)-xq).^2,2);
          end

          [sorted, I] = sort(dist,1);
          index = I(1);

          betaUse = beta1(index, 1:reg+1, reg);

          for j = 1:rows
            x2(j,1:reg) = x(j,1:reg).*betaUse(1:reg);
          end

          xq2 = [xq(1:reg).*betaUse(1:reg) 1];

          betaUse2 = beta2(index, 1:reg+1, reg);

          pred = xq2 * betaUse2';
          prediction = [prediction pred];
        end

      case 5
        % Previously calculated values must be in the right form
        beta1 = varargin{1};

        for i = 1:steps
          % The regressor of appropriate size
          [x, y] = regressor(data(1:columns), reg, i);
          rows = size(x,1);

          x2 = ones(size(x));

          dist = zeros(rows,1);

          for d = 1:rows
            dist(d) = sum((x(d,:)-xq).^2,2);
          end

          [sorted, I] = sort(dist,1);
          index = I(1);

          betaUse = squeeze(beta1(index, 1:reg+1, reg));

          for i = 1:rows
            x2(i,:) = x(i,:).*betaUse;
          end

          xq2 = xq .* betaUse;

          betaUse2 = Neighborhood(x2(index,:), ...
            x2, ...
            y, ...
            size(x2,2), 150)

          pred = xq2 * betaUse2';
          prediction = [prediction pred];
        end

      case 4
        for i = 1:steps
          % The regressor of appropriate size
          [x, y] = regressor(data, reg, i);
          rows = size(x,1);

          betaUse = Neighborhood(xq, ...
            x, ...
            y, ...
            size(x,2), 150);
          if sq == 1
            betaUse = sqrt(abs(betaUse));
          end

          x2 = [x(:,1:reg).*(ones(rows,1)*betaUse(1:reg)) ones(rows,1)];
          xq2 = [xq(1:reg).*betaUse(1:reg) 1];

          betaUse2 = Neighborhood(x2(index,:), ...
            x2, ...
            y, ...
            size(x2,2), 150);

          pred = xq2 * betaUse2';
          prediction = [prediction pred];
        end

      otherwise
        disp('Wrong number of arguments!');
        help Predict;
        Prediction = 0;
        return;
    end

  otherwise
    disp('There is no such a method!');
    help Predict
    prediction = 0;
    return;
end