function pred = PredictPLL(data, predpoint, neigh, steps, method, stephandle)

warning off;

maxreg = length(predpoint);
pred = [];

for s = 1:steps
  set(stephandle, 'string', ['Step ' num2str(s) ' of ' num2str(steps)]);
  drawnow;

  indexL = 1:maxreg;
  indexO = [];

  % Variable step depending on prediction method
  switch lower(method)
    case 'recursive'
      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg);
      [rows, columns] = size(x);

      xq = [predpoint pred];
      xq = [xq(end-maxreg+1:end) 1];

    case 'direct'
      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, s);
      [rows, columns] = size(x);

      xq = [predpoint 1];
  end

  dist = mean((ones(rows,1) * xq - x) .^ 2, 2);
  [Sorted, I] = sort(dist);
  xq = x(I(1), :);
  yq = y(I(1));
  x(I(1),:) = [];
  y(I(1)) = [];
  
  % Each regressor size
  for r = 1:columns-1
    error = ones(1, length(indexL))*inf;
    nn = ones(1, length(indexL))*inf;

    % Each column in its turn removed
    for i = 1:length(indexL)
      xx = x(:, [1:i-1 i+1:end]);
      xq2 = xq([1:i-1 i+1:end]);

      [beta, nn(i), waste2] = ...
        Neighborhood(xq2, xx, y, size(xx,2), neigh);
      error(i) = (yq - xq2 * beta') .^2;
    end

    % Taking column with lowest error out
    [aa, bb] = min(error);
    error2(r) = aa;
    nn2(r) = nn(bb);
    indexO = [indexO indexL(bb)];
    
    indexL(bb) = [];
    x(:,bb) = [];
    xq(bb) = [];
  end

  % Selecting inputs
  [aa, bb] = min(error2);
  inputs = sort(indexO(bb+1:end));
  clear error2 nn2;

  % Variable step depending on prediction method
  switch lower(method)
    case 'recursive'
      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg);

      xq = [predpoint pred];
      xq = xq(end-maxreg+1:end);

    case 'direct'
      % The regressor of appropriate size
      [x, y] = regressor(data, maxreg, s);

      xq = predpoint;
  end

  x = x(:, [inputs end]);
  xq = [xq(inputs) 1];

  % Predicting
  [beta, waste2, error] = ...
    Neighborhood(xq, x, y, size(x,2), neigh);

  pred = [pred xq * beta'];
end

