function [errorFinal, inputs, knn] = ...
  KNNPrune(data, reg, neigh, timestep, sampling, rounds, timehandle)

set(timehandle, 'string', 'Estimating calculation time...');
start = clock;
pempem = 1;

% In the case of LOO & Boot (and 632)
if sampling == 4
  method = 3;
else
  method = sampling;
end

[x, y] = regressor(data, reg, timestep, 'nobias');
[rows, columns] = size(x);

if method ~= 3
  bbb = round(rand(rows,rounds)*(rows-1))+1;
end

indexL = reg:-1:1;
indexO = [];
error = ones(1,reg)*inf;
drawnow;

warning off;

% Each regressor size
for r = 1:columns-1
  error_general = ones(1,max(size(indexL)))*inf;
  optneigh = ones(1,max(size(indexL)))*inf;

  % Each column in its turn removed
  for col = 1:max(size(indexL))
    xx = x(:, [1:col-1 col+1:end]);

    switch method
      case 1
        % This is for Bootstrap
        dist = zeros(rows,rows);
        yappIh = zeros(rows,neigh);

        for i=1:rows
          d1=mean((xx-ones(rows,1)*xx(i,:)).^2,2);
          dist(:,i) = d1;
          [I1,I2]=sort(d1);
          temp = cumsum(y(I2(1:neigh)))';
          yappIh(i,:)=temp./(1:neigh);
        end

        errappI=mean((yappIh-(y*ones(1,neigh))).^2);

        errval = zeros(rounds,neigh);
        errapp = zeros(rounds,neigh);

        for iii=1:rounds
          yapp=y(bbb(:,iii),end);
          distboot = dist(bbb(:,iii),:);
          [I1,I2]=sort(distboot);
          temp = cumsum(yapp(I2(1:neigh,:)),1)';
          yvalh = temp./(ones(rows,1)*(1:neigh));
          errval(iii,:)=mean((yvalh-(y*ones(1,neigh))).^2);

          I2 = I2(:,bbb(:,iii));
          temp = cumsum(yapp(I2(1:neigh,:)),1)';
          yapph = temp./(ones(rows,1)*(1:neigh));
          errapp(iii,:)=mean((yapph-(yapp*ones(1,neigh))).^2);
        end

        Errors = mean(errval-errapp)+errappI;

      case 2
        % This is for Bootstrap 632
        dist = zeros(rows,rows);
        yh = zeros(rows,neigh);

        for i=1:rows
          d1=mean((xx-ones(rows,1)*xx(i,:)).^2,2);
          dist(:,i) = d1;
          [I1,I2]=sort(d1);
          temp=cumsum(y(I2(1:neigh)))';
          yh(i,:)=temp./(1:neigh);
        end

        errappI=mean((yh-(y*ones(1,neigh))).^2);

        errval = zeros(rounds,neigh);

        for iii=1:rounds
          yapp=y(bbb(:,iii),end);
          [ccc,ia] = setdiff((1:rows)',bbb(:,iii));

          yval=y(ccc,end);
          distboot = dist(bbb(:,iii),ccc);
          s2=size(yval,1);

          [I1,I2]=sort(distboot,1);
          temp = cumsum(yapp(I2(1:neigh,:)),1)';
          yvalh = temp./(ones(s2,1)*(1:neigh));

          errval(iii,:)=mean((yvalh-(yval*ones(1,neigh))).^2);
        end

        Errors = mean(errval)*0.632+errappI*(1-0.632);
        
      case 3
        % This is for Leave-one-out
        Errors = ones(rows, neigh)*inf;

        for j = 1:rows
          xLoo = xx([1:j-1 j+1:rows],:);
          yLoo = y([1:j-1 j+1:rows]);

          [sorted, index] = sort(sum((ones(rows-1,1) * xx(j,:) - xLoo) .^ 2, 2));
          Errors(j,:) = ((cumsum(yLoo(index(1:neigh))')./(1:neigh)) - y(j)).^2;
        end

        Errors = mean(Errors, 1);
        
    end

    [error_general(col), optneigh(col)] = min(Errors)

    left = floor(etime(clock,start)/pempem*(reg^2/2+reg/2-pempem)/60)+1;
    set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
    drawnow;
    pempem = pempem + 1;
  end

  [aa, bb] = min(error_general);
  errorFinal(r) = aa
  neighFinal(r) = optneigh(bb)
  indexO = [indexO indexL(bb)]
  indexL(bb) = [];
  x(:,bb) = [];
end

indexO = [indexO indexL];

[aa, bb] = min(errorFinal);
inputs = sort(indexO(bb+1:end), 'descend');
knn = neighFinal(bb);

left = round(etime(clock,start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);
drawnow;

