function [errorFinal, inputs, neigh] = ...
  LL(data, reg, Neighbors, gl, timestep, sampling, rounds, timehandle);

set(timehandle, 'string', 'Estimating calculation time...');
start = clock;
pempem = 1;

[x, y] = regressor(data, reg, timestep);
[rows, columns] = size(x);

errorFinal = ones(1,reg)*inf;
drawnow;

warning off;

for r = 1:reg
  switch gl
    case 'Local'
      error = ones(rows,1) * inf;

      for i = 1:rows
        [waste, waste2, error(i)] = Neighborhood(x(i, end-r:end), ...
          x([1:i-1 i+1:end], end-r:end), y([1:i-1 i+1:end]), r+1, ...
          Neighbors);

        error(i) = (y(i) - waste * x(i,end-r:end)')^2;
      end

      errorFinal(r) = mean(error);

    case 'Global'
      error = ones(rows, Neighbors) * inf;

      for i = 1:rows
        xq = x(i, end-r:end);
        xLoo = x([1:i-1 i+1:end], end-r:end);
        yLoo = y([1:i-1 i+1:end]);

        dist = mean((ones(rows-1,1) * xq - xLoo) .^ 2, 2);
        [Sorted, I] = sort(dist);

        for j = r+1:Neighbors
          beta = xLoo(I(1:j),:)\yLoo(I(1:j));
          error(i,j) = (y(i) - xq * beta)^2;
        end
      end

      [errorFinal(r), neigh(r)] = min(mean(error, 1));

  end

  left = floor(etime(clock,start)/pempem*(reg-pempem)/60)+1;
  set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
  pempem = pempem + 1;
  drawnow;
end

[aa, bb] = min(errorFinal);
inputs = bb:-1:1;

if strcmp(gl, 'Local')
  neigh = 0;
end

left = round(etime(clock, start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);

