function [errorFinal, inputs, neighFinal] = ...
  LLPrune(data, reg, gl, Neighbors, timestep, sampling, rounds, timehandle)

set(timehandle, 'string', 'Estimating calculation time...');
start = clock;
pempem = 1;

[x, y] = regressor(data, reg, timestep);
[rows, columns] = size(x);

indexL = reg:-1:1;
indexO = [];
neighFinal = 0;
drawnow;

warning off;

% Each regressor size
for r = 1:columns-1
  error2 = ones(1, max(size(indexL)))*inf;
    
  % Each column in its turn removed
  for i = 1:max(size(indexL))
    xx = x(:, [1:i-1 i+1:end]);

    switch gl
      case 'Local'
        error = ones(rows, 1)*inf;

        % Each row
        for j = 1:rows
          [bim, bum, bom] = Neighborhood(xx(j,:), ...
            xx([1:j-1 j+1:end],:), y([1:j-1 j+1:end]), columns-r, Neighbors);

          error(j) = (y(j) - bim * xx(j,:)')^2;
        end
        
        error2(i) = mean(error);

      case 'Global'
        error = ones(rows, Neighbors)*inf;

        for j = 1:rows
          xq = xx(j, :);
          xLoo = xx([1:j-1 j+1:end], :);
          yLoo = y([1:j-1 j+1:end]);

          dist = mean((ones(rows-1,1) * xq - xLoo) .^ 2, 2);
          [Sorted, I] = sort(dist);

          for n = columns-r:Neighbors
            beta = xLoo(I(1:n),:)\yLoo(I(1:n));
            error(j,n) = (y(j) - xq * beta)^2;
          end
        end

        [error2(i), neigh(i)] = min(mean(error,1), [], 2)
        
    end
    
    left = floor(etime(clock,start)/pempem*(reg^2/2+reg/2-pempem)/60)+1;
    set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
    drawnow;
    pempem = pempem + 1;
  end

  [aa, bb] = min(error2)
  errorFinal(r) = aa;
  
  if strcmp(gl, 'Global')
    neighFinal(r) = neigh(bb);
    clear neigh;
  end
  
  indexO = [indexO indexL(bb)];
  indexL(bb) = []
  x(:,bb) = [];
end

[aa, bb] = min(errorFinal)
inputs = sort(indexO(bb+1:end), 'descend')

if strcmp(gl, 'Global')
  neighFinal = neighFinal(bb)
end

left = round(etime(clock,start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);
drawnow;

