function [errorFinal, inputs] = ...
  Linear(data, reg, timestep, sampling, rounds, timehandle);

set(timehandle, 'string', 'Estimating calculation time...');
start = clock;
pempem = 0.5;

[x, y] = regressor(data, reg, timestep);
[rows, columns] = size(x);

errorFinal = ones(1,reg)*inf;
drawnow;

switch sampling
  case 1
    bbb = round(rand(rows,rounds)*(rows-1))+1;

    for i = 1:columns-1
      xx = x(:, columns-i:columns);
      yy = y;
      A = xx\yy;
      pred = x(:,columns-i:columns)*A;
      eInitial = mean((pred - yy).^2);

      eLearn = ones(1,rounds)*inf;
      eValid = ones(1,rounds)*inf;

      for j = 1:rounds
        xx = x(bbb(:,j), columns-i:columns);
        yy = y(bbb(:,j));
        A = xx\yy;
        pred = xx*A;
        eLearn(j) = mean((pred - yy).^2);
        pred = x(:, columns-i:columns)*A;
        eValid(j) = mean((pred - y).^2);
      end

      errorFinal(i) = eInitial + mean(eValid) - mean(eLearn);

      left = floor(etime(clock,start)/pempem*(columns-pempem)/60)+1;
      set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
      drawnow;
      pempem = pempem + 1;
    end

  case 2
    bbb = round(rand(rows,rounds)*(rows-1))+1;

    for i = 1:columns-1
      xx = x(:, columns-i:columns);
      yy = y;
      A = xx\yy;
      pred = x(:,columns-i:columns)*A;
      eInitial = mean((pred - yy).^2);

      eLearn = ones(1,rounds)*inf;

      for j = 1:rounds
        ccc = setdiff([1:rows]', bbb(:,j));
        xx = x(ccc, columns-i:columns);
        yy = y(ccc);
        A = xx\yy;
        pred = x(bbb(:,j), columns-i:columns)*A;
        eLearn(j) = mean((pred - y(bbb(:,j))).^2);
      end

      errorFinal(i) = (1 - 0.632) * eInitial + 0.632 * mean(eLearn);

      left = floor(etime(clock,start)/pempem*(columns-pempem)/60)+1;
      set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
      drawnow;
      pempem = pempem + 1;
    end

  case 3
    for i = 1:columns-1
      error = ones(1,rows)*inf;

      for j = 1:rows
        xx = x([1:j-1 j+1:end],columns-i:columns);
        yy = y([1:j-1 j+1:end]);
        A = xx\yy;
        pred = x(j,columns-i:columns)*A;
        error(j) = (pred - y(j))^2;
      end

      errorFinal(i) = mean(error);

      left = floor(etime(clock,start)/pempem*(columns-pempem)/60)+1;
      set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
      drawnow;
      pempem = pempem + 1;
    end

end

[aa, bb] = min(errorFinal);
inputs = bb:-1:1;

left = round(etime(clock,start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);

