function [errorFinal, inputs] = ...
  LinearPrune(data, reg, timestep, sampling, rounds, timehandle);

set(timehandle, 'string', 'Estimating calculation time...');
start = clock;
pempem = 1;

[x, y] = regressor(data, reg, timestep);
[rows, columns] = size(x);

errorFinal = [];
inputs = [];
indexes = reg:-1:1;
drawnow;

while(1)
  error2 = ones(1,columns)*inf;
  
  for i = 1:columns-1
    error = ones(1,rows)*inf;

    switch sampling
      case 1
        bbb = round(rand(rows,rounds)*(rows-1))+1;


        xx = x(:, [1:i-1 i+1:end]);
        yy = y;
        A = xx\yy;
        pred = x(:, [1:i-1 i+1:end])*A;
        eInitial = mean((pred - yy).^2);

        eLearn = ones(1,rounds)*inf;
        eValid = ones(1,rounds)*inf;

        for j = 1:rounds
          xx = x(bbb(:,j), [1:i-1 i+1:end]);
          yy = y(bbb(:,j));
          A = xx\yy;
          pred = xx*A;
          eLearn(j) = mean((pred - yy).^2);
          pred = x(:, [1:i-1 i+1:end])*A;
          eValid(j) = mean((pred - y).^2);
        end

        error2(i) = eInitial + mean(eValid) - mean(eLearn);

      case 2
        bbb = round(rand(rows,rounds)*(rows-1))+1;

        xx = x(:, [1:i-1 i+1:end]);
        yy = y;
        A = xx\yy;
        pred = x(:, [1:i-1 i+1:end])*A;
        eInitial = mean((pred - yy).^2);

        eLearn = ones(1,rounds)*inf;

        for j = 1:rounds
          ccc = setdiff([1:rows]', bbb(:,j));
          xx = x(ccc, [1:i-1 i+1:end]);
          yy = y(ccc);
          A = xx\yy;
          pred = x(bbb(:,j), [1:i-1 i+1:end])*A;
          eLearn(j) = mean((pred - y(bbb(:,j))).^2);
        end

        error2(i) = (1 - 0.632) * eInitial + 0.632 * mean(eLearn);

      case 3
        for j = 1:rows
          xx = x([1:j-1 j+1:end], [1:i-1 i+1:end]);
          yy = y([1:j-1 j+1:end]);
          A = xx\yy;
          pred = x(j, [1:i-1 i+1:end])*A;
          error(j) = (pred - y(j))^2;
        end

        error2(i) = mean(error);
    end
    
    left = floor(etime(clock,start)/pempem*(reg^2/2+reg/2-pempem)/60)+1;
    set(timehandle, 'string', ['Time left: ' num2str(left) ' minutes']);
    drawnow;
    pempem = pempem + 1;
  end

  [aa, bb] = min(error2);
  errorFinal = [errorFinal aa];
  inputs = [inputs indexes(bb)];

  indexes(bb) = [];
  x(:, bb) = [];
  columns = columns - 1;

  if columns == 1
    break;
  end
end

[aa, bb] = min(errorFinal);
inputs = sort(inputs(bb+1:end), 'descend');

left = round(etime(clock,start)/60);
set(timehandle, 'string', ['Calculation took ' num2str(left) ' minutes']);
drawnow;
