function pred = PredictKNN(data, inputs, steps, method, neighs)

pred = [];

switch method
  case 'recursive'
    index = inputs(1,:);
    maxreg = max(index);
    index(find(index == 0)) = [];
    index = ones(1,length(index)) * (maxreg+1) - index;    
    neigh = neighs(1,1);

    [x, y] = regressor(data, maxreg, 'nobias');
    x = x(:, index);
    [rows, columns] = size(x);

    for i = 1:steps
      xq = [data pred];
      xq = xq(end-maxreg+1:end);
      xq = xq(index);

      [sorted, III] = sort(sum((ones(rows,1) * xq - x) .^ 2, 2));
      pred = [pred mean(y(III(1:neigh)))];
    end

  case 'direct'
    for i = 1:steps
      maxreg = max(inputs(i,:));
      neigh = neighs(i,1);

      index = inputs(i,:);
      index(find(index == 0)) = [];
      index = ones(1,length(index)) * (max(index)+1) - index;

      [x, y] = regressor(data, maxreg, i, 'nobias');
      x = x(:, index);
      [rows, columns] = size(x);

      xq = data(end-maxreg+1:end);
      xq = xq(index);

      [sorted, III] = sort(sum((ones(rows,1) * xq - x) .^ 2, 2));
      pred = [pred mean(y(III(1:neigh)))];
    end
end

