function [x, y] = regressor(data, varargin)

% Usage: [x, y] = regressor(data, size, t, 'nobias');
% 
% Input arguments:
%
% data    Given data from which the regressor matrix x and output
%         matrix y are formed. Data should be a vector, not a matrix
% size    Optional size of the regressor. If not defined by user
%         default is 20.
% t       Optional long term prediction bias. Makes predicting
%         directly to further away from last data point. If not
%         defined by user default is 1, which is next unknown data point.
% nobias  Suppresses the bias from the output vector. If not defined bias
%         will be included in the output.
%
% Output arguments:
%
% x       Input (regressor matrix)
% y       Output (result column vector)

if nargin > 1 & strcmp(varargin{nargin-1}, 'nobias')
  bias = 0;
  nargleft = nargin - 1;
else
  bias = 1;
  nargleft = nargin;
end

switch nargleft
 case 3
  K = varargin{1};
  t = varargin{2};
 case 2
  K = varargin{1};
  t = 1;
 case 1
  K = 20;
  t = 1;
 otherwise
  disp('Wrong number of input arguments!');
  help regressor;
  return;
end

if size(data,1) <= size(data,2)
  data = data';
end

D = size(data,1);
y = data(K+t:D);

x = ones(D-K-t+1,K+bias);

for i = 1:K
  x(:,i) = data(i:D-K-t+i);
end