function [x, y] = regressor2(data, varargin)

% Usage: [x, y] = regressor2(data, size, t, 'nobias');
%
% Note: Uses also regressor-function!
%
% Input arguments:
%
% data    Given data from which the regressor matrix x and output
%         matrix y are formed. Data should be a vector, not a matrix
% size    Optional size of the regressor. If not defined by user
%         default is 20.
% t       Optional parameter, which defines the number of output columns to
%         produce to the output matrix. Default is 1.
% nobias  Suppresses the bias from the output vector. If not defined bias
%         will be included in the output.
%
% Output arguments:
%
% x       Input (regressor matrix)
% y       Output (result column vector or matrix)

if nargin > 1 & strcmp(varargin{nargin-1}, 'nobias')
  bias = 0;
  nargleft = nargin - 1;
else
  bias = 1;
  nargleft = nargin;
end

switch nargleft
  case 3
    K = varargin{1};
    t = varargin{2};
  case 2
    K = varargin{1};
    t = 1;
  case 1
    K = 20;
    t = 1;
  otherwise
    disp('Wrong number of input arguments!');
    help regressor2;
    return;
end

try
  [x, y] = regressor(data, K+t-1, 'nobias');
catch
  disp('Either file regressor.m not found or wrong number of input arguments!');
  help regressor2;
  return;
end

y = [x(:,K+1:end) y];
x = x(:,1:K);

if bias == 1
  x = [x ones(size(x,1),1)];
end
