function [dmean, dgamma] = bfgs_grad_wrapper(mean, var_gamma, auxdata)
%Wrapper for cost function gradient with respect to mean and gamma
%Copyright (C) 2008-2010 Mikael Kuusela.

global g_calls;
g_calls = g_calls + 1;

global excess_time;
t_excess = cputime;
[alpha_0, beta_0, v_0, W_0, invW_0, mean_0, K, N, X, D, const_gamma, t, run] = auxdata{:};
gamma = [var_gamma const_gamma];
res = gamma_to_res(gamma, auxdata);
helper = bfgs_helper_values(res, auxdata);
[N_eff, x_avg, S, alpha, beta, v, W, pi_eff, lambda_eff] = helper{:};
excess_time(run) = excess_time(run) + cputime - t_excess;

[dmean dgamma] = grad_m_gamma_bfgs(mean_0, beta_0, res, N_eff, x_avg, beta, mean, v, W, pi_eff, lambda_eff, K, N, X, D);