function r = nat_grad_m_gamma(mean_0, beta_0, res, N_eff, x_avg, beta, mean, v, W, pi_eff, lambda_eff, K, N, X, D)
%Calculate the natural gradient of the variational cost with respect to
%means and gammas.
%Copyright (C) 2008-2010 Mikael Kuusela.

%Components of natural gradient corresponding to means
r1 = zeros(D*K,1);
for k=1:K
    r1((k-1)*D+1:(k-1)*D+D) = -(1/(beta_0+N_eff(k))*(beta_0*mean_0 + N_eff(k)*x_avg(:,k))-mean(:,k));
end

%Components of standard gradient corresponding to gammas
E = grad_E(res, pi_eff, lambda_eff, D, beta, v, X, mean, W, N, K);
F = zeros(1,N);
for i=1:N
    for k=1:K
        F(i) = F(i) + E(i,k);
    end
end    
r2 = zeros(N,K-1);
for i=1:N
    for j=1:(K-1)
        r2(i,j) = E(i,j)-res(i,j)*F(i);        
    end
end
r2 = reshape(r2',[],1);

%Both means and gammas
r = cat(1,r1,r2);

if K > 1 %Doesn't have to be evaluated if K=1
    
    %Calculate diagonal blocks of G  
    G_blk_res = zeros(K-1,K-1,N);
    for n=1:N
        G_blk_res(:,:,n) = -res(n,1:(end-1))'*res(n,1:(end-1)) + diag(res(n,1:(end-1))) + eps*eye(K-1);
    end

    %Natural gradient for gammas
    for n=1:N
        r(D*K+(n-1)*(K-1)+1:D*K+(n-1)*(K-1)+(K-1)) = G_blk_res(:,:,n)\r(D*K+(n-1)*(K-1)+1:D*K+(n-1)*(K-1)+(K-1));
    end
end    