function bfgs_callback_wrapper(iter, cost, mean, var_gamma, auxdata)
%Record CPU time and cost on each BFGS iteration
%Copyright (C) 2008-2010 Mikael Kuusela.

[alpha_0, beta_0, v_0, W_0, invW_0, mean_0, K, N, X, D, const_gamma, t, run] = auxdata{:};

global costValues_m_gamma_bfgs;
time = cputime - t;
costValues_m_gamma_bfgs(iter,:,run) = [time,cost]; %Record time and cost

%{
global f_calls;
global g_calls;
disp(strcat('f: ',num2str(f_calls)));
disp(strcat('g: ',num2str(g_calls)));
if f_calls == g_calls
    disp('same');
else
    disp('not same!');
end
f_calls = 0;
g_calls = 0;

format long;
disp(cost);

gamma = [var_gamma const_gamma];
res = gamma_to_res(gamma, auxdata);
helper = bfgs_helper_values(res, auxdata);
[N_eff, x_avg, S, alpha, beta, v, W, pi_eff, lambda_eff] = helper{:};

plot_final_MoG(alpha, v, W, mean, beta, K, D, X, cost);
%}