#! /usr/bin/env python
# -*- coding: iso-8859-1 -*-

#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#

from __future__ import nested_scopes #needed for python2.1
import bblocks.PickleHelpers as PickleHelpers
import os
import re
import corrs
import math
import sys

#This is to correct problems we had with time.clock() wrapping around
def totaltime(hnfanet):
    t=map(lambda x:x[4],filter(lambda x:x[0]=='Iteration',
                               hnfanet.learner.history))
    wraps = 0
    for i in range(len(t)-1):
        if t[i] > t[i+1]:
            wraps = wraps + 1
    return t[-1] + wraps*math.exp(32*math.log(2)-6*math.log(10))

def loadhnfasnr(res,sig, m='nl1_n8.*\.pickle\.gz$', dir=('.')):
    for d in dir:
        dd=os.path.expanduser(d);
        l=os.listdir(dd)
        l=filter(lambda x:re.search(m,x), l)
        for x in l:
            base=re.sub('\.pickle(\.gz)?$','',x)
            if res.has_key(base):
                continue
            print base,
            sys.stdout.flush()
            hnfanet=PickleHelpers.load_compat(os.path.join(dd,x))
            cost=hnfanet.net.Cost()
            time=totaltime(hnfanet)
            a=len(hnfanet.net.GetNodes('s\(1'))
            snr=corrs.corrs(hnfanet,sig=sig)
            print "."
            sys.stdout.flush()
            res[base] = (snr[5], snr, cost, time, a, os.path.join(dd,x))

sig=corrs.loadsig('nl1-inputs.pickle')
res={}
loadhnfasnr(res, sig=sig)
PickleHelpers.SaveWithPickle(res, 'res.pickle.gz')

f=open('cost_snr.asc','w+')
for k in res.keys():
    f.write(`res[k][2]`+' '+`res[k][0]`)
    f.write('\n')

f.close()
