# -*- coding: iso-8859-1 -*-

#
# This file is a part of the Bayes Blocks library
#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#
# $Id: Label.py 5 2006-10-26 09:44:54Z ah $
#

def Label(name, *inds):
    """Label(name, seq) or Label(name [, index [, index ...]])
    
    Creates a label string of the form 'name(index, index, ...)'
    Indices can be given as a tuple or a list"""
    if len(inds) == 1 and (type(inds[0]) in (type(()), type([]))):
        inds = tuple(inds[0])
    if inds == ():
        return name
    elif len(inds) == 1:
        return name + "(" + `inds[0]` + ")"
    else:
        return name + `inds`

def Unlabel(label):
    """stem, indices = Unlabel(label)
    
    Inverts the operation label = Label(stem, indices)
    Returns the stem and a tuple with indices."""
    pos = label.find('(')
    if pos >= 0:
        stem = label[:pos]
        tailpos = label.find('_', pos)
        if tailpos > 0:
            stem += label[tailpos:]
            tup = eval(label[pos:tailpos])
        else:
            tup = eval(label[pos:])
        if type(tup) != type(()):
            tup = (tup, )
    else:
        stem = label
        tup = ()
    return stem, tup
