// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: MatlabSaver.h 5 2006-10-26 09:44:54Z ah $

#ifndef MATLABSAVER_H
#define MATLABSAVER_H

#include "Templates.h"
#ifdef WITH_MATLAB
#include "Saver.h"
#include <matrix.h>
#include <mat.h>

#ifdef __OLD_MATLAB__
mxArray *mxCreateDoubleScalar(const double val);
#endif

class MatlabSaver : public ConcreteSaver
{
public:
  MatlabSaver(string filename, string varname);
  virtual ~MatlabSaver();
  virtual void SaveIt();

  virtual void StartEnumeratedContainer(int size, string name);
  virtual void StartNamedContainer(string name);
  virtual void CloseEnumeratedContainer(string name);
  virtual void CloseNamedContainer(string name);
  virtual void StartNode(string type);
  virtual void CloseNode(string type);
  virtual void SetDouble(double val) { 
    SetArray(mxCreateDoubleScalar(val));
  }
  virtual void SetInt(int val) {
    SetArray(mxCreateDoubleScalar((double) val));
  }
  virtual void SetBool(bool val) {
    SetArray(mxCreateDoubleScalar((double) val));
  }
  virtual void SetString(string val) {SetArray(mxCreateString(val.c_str())); }
  virtual void SetLabel(Label val) { SetArray(DumpLabel(val)); }
  virtual void SetDV(DV val) { SetArray(DumpDV(val)); }
  virtual void SetDFlags(DFlags val) { SetArray(DumpDFlags(val)); }
  virtual void SetDSSet(DSSet val) { SetArray(DumpDSSet(val)); }
  virtual void SetDVSet(DVSet val) { SetArray(DumpDVSet(val)); }
  virtual void SetDVH(DVH val) { SetArray(DumpDVH(val)); }
  virtual void SetDD(DD val) { SetArray(DumpDD(val)); }
  virtual void SetVDD(VDD val) { SetArray(DumpVDD(val)); }
  virtual void SetIntV(IntV val) { SetArray(DumpIntV(val)); }
  virtual void SetNamedDouble(string name, double val) {
    SetNamedArray(name, mxCreateDoubleScalar(val));
  }
  virtual void SetNamedInt(string name, int val) {
    SetNamedArray(name, mxCreateDoubleScalar(val));
  }
  virtual void SetNamedBool(string name, bool val) {
    SetNamedArray(name, mxCreateDoubleScalar(val));
  }
  virtual void SetNamedString(string name, string val) {
    SetNamedArray(name, mxCreateString(val.c_str()));
  }
  virtual void SetNamedLabel(string name, Label val) {
    SetNamedArray(name, DumpLabel(val));
  }
  virtual void SetNamedDV(string name, DV val) {
    SetNamedArray(name, DumpDV(val));
  }
  virtual void SetNamedDFlags(string name, DFlags val) {
    SetNamedArray(name, DumpDFlags(val));
  }
  virtual void SetNamedDSSet(string name, DSSet val) {
    SetNamedArray(name, DumpDSSet(val));
  }
  virtual void SetNamedDVSet(string name, DVSet val) {
    SetNamedArray(name, DumpDVSet(val));
  }
  virtual void SetNamedDVH(string name, DVH val) {
    SetNamedArray(name, DumpDVH(val));
  }
  virtual void SetNamedDD(string name, DD val) {
    SetNamedArray(name, DumpDD(val));
  }
  virtual void SetNamedVDD(string name, VDD val) {
    SetNamedArray(name, DumpVDD(val));
  }
  virtual void SetNamedIntV(string name, IntV val) {
    SetNamedArray(name, DumpIntV(val));
  }

private:
  void SetNamedArray(string name, mxArray *val);
  void SetArray(mxArray *val);
  mxArray *DumpDFlags(const DFlags f);
  mxArray *DumpDSSet(const DSSet f);
  mxArray *DumpDV(const DV f);
  mxArray *DumpDVSet(const DVSet f);
  mxArray *DumpDVH(const DVH f);
  mxArray *DumpDD(const DD f);
  mxArray *DumpVDD(const VDD f);
  mxArray *DumpIntV(const IntV f);
  // Convert the labels to be better suited for Matlab use
  mxArray *DumpLabel(const Label f);

  vector<mxArray *> open_named_containers;
  vector<mxArray *> open_enum_containers;
  vector<int> enum_container_indices;
  enum last_container_types { NONE, NAMED, ENUMER };
  vector<last_container_types> last;
  mxArray *root_node;
  string filename;
  string varname;
  bool saved;
};
#endif // WITH_MATLAB

#endif // MATLABSAVER_H
