//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: Net.i 7 2006-10-26 10:26:41Z ah $

%module(package="bblocks") Net

#ifndef SWIGPYTHON
#error "Only Python is supported for now."
#endif

%init %{
#if defined(WITH_NUMERIC) || defined(WITH_NUMPY)
  import_array(); /* load the Numeric PyCObjects */
#endif
%}

%{
#include <stdexcept>
  class IndexException { };

#define __PYTHON_H_INCLUDED__

#include "Templates.h"

#ifdef WITH_NUMPY
#include "numpy/arrayobject.h"
#endif
#ifdef WITH_NUMERIC
#define PY_ARRAY_UNIQUE_SYMBOL __py_numeric_array__
#include "Numeric/arrayobject.h"
#endif

#include "Decay.h"
#include "DecayCounter.h"
#include "Net.h"
#include "Node.h"
#include "NodeFactory.h"
#include "Saver.h"
#ifdef WITH_MATLAB
#include <matrix.h>
#include <mat.h>
#endif
#include "MatArray.h"
%}

#define BUILDING_SWIG_INTERFACE
#define WITH_PYTHON
#define __PYTHON_H_INCLUDED__

%include exception.i

%typemap(out) Node *, Variable * = SWIGTYPE *DYNAMIC;

%{
static swig_type_info * Node_dynamic_cast(void **ptr)
{
  Node **nptr = (Node **) ptr;
  Variable *e = dynamic_cast<Variable *>(*nptr);
  if (e) {
    *ptr = (void *) e;
    return SWIGTYPE_p_Variable;
  }
  OnLineDelay *ol = dynamic_cast<OnLineDelay *>(*nptr);
  if (ol) {
    *ptr = (void *) ol;
    return SWIGTYPE_p_OnLineDelay;
  }
  DelayV *delay = dynamic_cast<DelayV *>(*nptr);
  if (delay) {
    *ptr = (void *) delay;
    return SWIGTYPE_p_DelayV;
  }
  SumN *s = dynamic_cast<SumN *>(*nptr);
  if (s) {
    *ptr = (void *) s;
    return SWIGTYPE_p_SumN;
  }
  SumNV *sv = dynamic_cast<SumNV *>(*nptr);
  if (sv) {
    *ptr = (void *) sv;
    return SWIGTYPE_p_SumNV;
  }

  return 0;
}

static swig_type_info * Variable_dynamic_cast(void **ptr)
{
  Variable **nptr = (Variable **) ptr;
  Evidence *e = dynamic_cast<Evidence *>(*nptr);
  if (e) {
    *ptr = (void *) e;
    return SWIGTYPE_p_Evidence;
  }
  EvidenceV *ev = dynamic_cast<EvidenceV *>(*nptr);
  if (ev) {
    *ptr = (void *) ev;
    return SWIGTYPE_p_EvidenceV;
  }
  SparseGaussV *sgv = dynamic_cast<SparseGaussV *>(*nptr);
  if (sgv) {
    *ptr = (void *) sgv;
    return SWIGTYPE_p_SparseGaussV;
  }
  return 0;
}
%}

DYNAMIC_CAST(SWIGTYPE_p_Node, Node_dynamic_cast);
DYNAMIC_CAST(SWIGTYPE_p_Variable, Variable_dynamic_cast);

%include std_string.i

%include std_vector.i
namespace std {
  %template(IntV) vector<int>;
  %template(DV) vector<double>;
};

%typemap(out) double &, double * {
  $result = Py_BuildValue("d", *$1);
}

%typemap(in,numinputs=0) DD *&OUTPUT(DD *temp) {
  $1 = &temp;
}

%typemap(argout) DD *&OUTPUT {
  if ($result != Py_None) {
    Py_DECREF($result);
    $result = SWIG_NewPointerObj((void *) *$1, SWIGTYPE_p_DD, 0);
  }
}

%typemap(out) BOOLASOBJ {
  if ($1)
    $result = PyInt_FromLong((long)$1);
  else
    $result = Py_None;
}

%apply(DD *&OUTPUT) { DD *&val };

%typemap(out) PyObject * {
  $result = $1;
}

%typemap(in) PyObject * {
  $1 = $input;
}

// %rename(ClampDV) Variable::Clamp(DV &);
// %rename(ClampDD) Variable::Clamp(DD &);
// %rename(ClampVDD) Variable::Clamp(VDD &);
// %rename(ClampInt) Variable::Clamp(int);
// %rename(ClampWithVar) Variable::Clamp(double, double);
// %rename(ClampWithVarV) Variable::Clamp(DV &, DV &);


%exception {
  try {
    $action
  } catch(IndexException) {
    SWIG_exception(SWIG_IndexError, "Index out of bounds");
  } catch(TypeException &e) {
    SWIG_exception(SWIG_TypeError, e.what());
  } catch(std::exception &e) {
    SWIG_exception(SWIG_RuntimeError, e.what());
  } catch(...) {
    SWIG_exception(SWIG_RuntimeError,"Unknown exception");
  }
}

%newobject CreateNetFromPyObject(PyObject *);

%include "Templates.h"

%extend DD {
  double __getitem__(int i) {
    if (i < 0 && -i <= (int)self->size())
      return self->operator[](self->size()+i);
    else if (i < (int)self->size()) 
      return self->operator[](i);
    else
      throw IndexException();
  }
  void __setitem__(int i, double val) {
    if (i < 0 && -i <= (int)self->size())
      self->operator[](self->size()+i) = val;
    else if (i < (int)self->size()) 
      self->operator[](i) = val;
    else
      throw IndexException();
  }
  int __len__() { return self->size(); }
};

%include "Decay.h"
%include "DecayCounter.h"
%include "Net.h"
%include "Node.h"
%include "NodeFactory.h"
%include "MatArray.h"

%pythoncode {
def _Node__getstate__(self):
    return {'label': self.GetLabel(),
            'net': self.GetNet()}
def _Node__setstate__(self, dict):
    self.this = dict['net'].GetNode(dict['label']).this
    self.this.disown()
    self.__class__ = self.this.__class__

Node.__getstate__ = _Node__getstate__
Node.__setstate__ = _Node__setstate__
}
