// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: NodeFactory.h 5 2006-10-26 09:44:54Z ah $

#ifndef NODEFACTORY_H
#define NODEFACTORY_H

#include "Node.h"

class Net;

class NodeFactory {
 public:
  NodeFactory(Net *_net) : net(_net) { };
  virtual ~NodeFactory() { }

  virtual Constant *GetConstant(Label label, double v) const;
  virtual ConstantV *GetConstantV(Label label, DV v) const;

  virtual Rectification *GetRectification(Label label, Node *n) const;
  virtual RectificationV *GetRectificationV(Label label, Node *n) const;
  virtual Prod *GetProd(Label label, Node *n1, Node *n2) const;
  virtual ProdV *GetProdV(Label label, Node *n1, Node *n2) const;
  virtual Sum2 *GetSum2(Label label, Node *n1, Node *n2) const;
  virtual Sum2V *GetSum2V(Label label, Node *n1, Node *n2) const;
  virtual SumN *GetSumN(Label label) const;
  virtual SumNV *GetSumNV(Label label) const;
  virtual DelayV *GetDelayV(Label label, Node *n1, Node *n2) const;

  virtual Proxy *GetProxy(Label label, Label rlabel) const;
  virtual Relay *GetRelay(Label label, Node *n) const;
  virtual Evidence *GetEvidence(Label label, Node *n) const;
  virtual EvidenceV *GetEvidenceV(Label label, Node *n) const;

  virtual Gaussian *GetGaussian(Label label, Node *n1, Node *n2) const;
  virtual GaussianV *GetGaussianV(Label label, Node *n1, Node *n2) const;
  virtual RectifiedGaussian *GetRectifiedGaussian(Label label, Node *n1, Node *n2) const;
  virtual RectifiedGaussianV *GetRectifiedGaussianV(Label label, Node *n1, Node *n2) const;
  virtual GaussRect *GetGaussRect(Label label, Node *n1, Node *n2) const;
  virtual GaussRectV *GetGaussRectV(Label label, Node *n1, Node *n2) const;
  virtual MoG *GetMoG(Label label, Node *n) const;
  virtual MoGV *GetMoGV(Label label, Node *n) const;
  virtual DelayGaussV *GetDelayGaussV(Label label, Node *n1, Node *n2, Node *n3, Node *n4, Node *n5) const;
  virtual SparseGaussV *GetSparseGaussV(Label label, Node *n1, Node *n2) const;
  virtual GaussNonlin *GetGaussNonlin(Label label, Node *n1, Node *n2) const;
  virtual GaussNonlinV *GetGaussNonlinV(Label label, Node *n1, Node *n2) const;
  virtual Discrete *GetDiscrete(Label label) const;
  virtual DiscreteV *GetDiscreteV(Label label) const;
  virtual DiscreteDirichlet *GetDiscreteDirichlet(Label label, Dirichlet *d) const;
  virtual DiscreteDirichletV *GetDiscreteDirichletV(Label label, Dirichlet *d) const;
  virtual Dirichlet *GetDirichlet(Label label, ConstantV *c) const;

  virtual Memory *GetMemory(Label label, Node *n) const;
  virtual OLDelayS *GetOLDelayS(Label label, Node *n1, Node *n2) const;
  virtual OLDelayD *GetOLDelayD(Label label, Node *n1, Node *n2) const;


  /* Returns the net to which this factory is creating nodes. */
  Net *GetNet() const;
  
 private:
  Net *net;
};


#endif // NODEFACTORY_H
