// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: PythonLoader.h 7 2006-10-26 10:26:41Z ah $

#ifndef PYTHONLOADER_H
#define PYTHONLOADER_H

#include "Templates.h"
#ifdef WITH_PYTHON
#ifndef __PYTHON_H_INCLUDED__
#error "Python.h must be included before this file.  (It must also be included before any system include files.)"
#endif // not __PYTHON_H_INCLUDED

#if PY_VERSION_HEX < 0x02050000 && !defined(PY_SSIZE_T_MIN)
typedef int Py_ssize_t;
#define PY_SSIZE_T_MAX INT_MAX
#define PY_SSIZE_T_MIN INT_MIN
#endif

#include "Loader.h"

/**********************************
**  Class PythonLoader
*/
class PythonLoader : public ConcreteLoader
{
public:
  PythonLoader(PyObject *obj);
  virtual ~PythonLoader();

  virtual void LoadIt();

  virtual int StartEnumeratedContainer(string name);
  virtual int StartNamedContainer(string name);
  virtual void CloseEnumeratedContainer(string name);
  virtual void CloseNamedContainer(string name);

  virtual int StartNode(string & type);
  virtual void CloseNode(string type);

  virtual int GetDouble(double &val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    val = ToDouble(obj);
    return 1;
  }
  virtual int GetInt(int &val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    val = ToInt(obj);
    return 1;
  }
  virtual int GetBool(bool & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    val = ToBool(obj);
    return 1;
  }
  virtual int GetString(string & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    val = ToString(obj);
    return 1;
  }
  virtual int GetLabel(Label & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    val = ToString(obj);
    return 1;
  }
  virtual int GetDV(DV & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDV(obj, val);
    return 1;
  }
  virtual int GetDFlags(DFlags & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDFlags(obj, val);
    return 1;
  }
  virtual int GetDSSet(DSSet & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDSSet(obj, val);
    return 1;
  }
  virtual int GetDVSet(DVSet & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDVSet(obj, val);
    return 1;
  }
  virtual int GetDVH(DVH & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDVH(obj, val);
    return 1;
  }
  virtual int GetDD(DD & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToDD(obj, val);
    return 1;
  }
  virtual int GetVDD(VDD & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToVDD(obj, val);
    return 1;
  }
  virtual int GetIntV(IntV & val)
  {
    PyObject *obj = GetArray();
    if (!obj)
      return 0;
    ToIntV(obj, val);
    return 1;
  }

  /********************************
  **  Named
  */
  virtual int GetNamedDouble(string name, double &val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    val = ToDouble(obj);
    return 1;
  }
  virtual int GetNamedInt(string name, int &val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    val = ToInt(obj);
    return 1;
  }

  virtual int GetNamedBool(string name, bool & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    val = ToBool(obj);
    return 1;
  }

  virtual int GetNamedString(string name, string & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    val = ToString(obj);
    return 1;
  }

  virtual int GetNamedLabel(string name, Label & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    val = ToString(obj);
    return 1;
  }

  virtual int GetNamedDV(string name, DV & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDV(obj, val);
    return 1;
  }

  virtual int GetNamedDFlags(string name, DFlags & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDFlags(obj, val);
    return 1;
  }

  virtual int GetNamedDSSet(string name, DSSet & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDSSet(obj, val);
    return 1;
  }

  virtual int GetNamedDVSet(string name, DVSet & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDVSet(obj, val);
    return 1;
  }

  virtual int GetNamedDVH(string name, DVH & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDVH(obj, val);
    return 1;
  }

  virtual int GetNamedDD(string name, DD & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToDD(obj, val);
    return 1;
  }

  virtual int GetNamedVDD(string name, VDD & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToVDD(obj, val);
    return 1;
  }

  virtual int GetNamedIntV(string name, IntV & val)
  {
    PyObject *obj = GetNamedArray(name);
    if (!obj)
      return 0;
    ToIntV(obj, val);
    return 1;
  }

private:
  PyObject *GetNamedArray(string name);
  PyObject *GetArray();

  double ToDouble(PyObject * obj)
  {
    return PyFloat_AsDouble(obj);
  }
  int ToInt(PyObject * obj)
  {
    return (int) PyInt_AsLong(obj);
  }
  bool ToBool(PyObject * obj)
  {
    return (bool) PyInt_AsLong(obj);
  }
  string ToString(PyObject * obj);

  void ToDV(PyObject * obj, DV & val);
  void ToDV_fromArray(PyObject * obj, DV & val);
  void ToDV_fromList(PyObject * obj, DV & val);
  void ToDFlags(PyObject * obj, DFlags & val);
  void ToDSSet(PyObject * obj, DSSet & val);
  void ToDVSet(PyObject * obj, DVSet & val);
  void ToDVH(PyObject * obj, DVH & val);
  void ToDD(PyObject * obj, DD & val);
  void ToVDD(PyObject * obj, VDD & val);
  void ToIntV(PyObject * obj, IntV & val);

  vector < PyObject * > open_cont;	// OPEN CONTainers

  vector < Py_ssize_t > ec_ix;	// Enumerated Container's IndeX

  enum last_container_types {
    NONE, NAMED, ENUMER
  };
  vector < last_container_types > last;
  PyObject *root_node;
};

#endif // WITH_PYTHON
#endif // PYTHONLOADER_H
