# -*- coding: iso-8859-1 -*-

#
# This file is a part of the Bayes Blocks library
#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#
# $Id: fixNet.py 6 2006-10-26 09:54:58Z ah $
#

# This programs fixes the constructors of nodes created by swig.
# All subclasses of "Node" are maintained by "Net".  When "Net"
# is deleted it deletes all Nodes which belong to it.  This means
# that the Python should not delete the nodes.  This behaviour is
# controlled by "thisown" field of nodes.  Swig creates constructors
# which sets the value to 1.  This program rewrites those parts so
# that thisown field is set to 0.

# The program keeps a list of all subclasses of "Node" in variable classes.
# When a new class definition is encountered, it is assumed that exactly three
# lines further will be the command "self.thisown = 1".  This is the behaviour
# of SWIG version 1.3.7.  The structure of the constructor might be different
# in future versions and this file should then be altered accordingly.

# As of SWIG version 1.3.19, the format of setting self.thisown has changed to
# "_swig_setattr(self, Classname, 'thisown', 1)"
# The program has been updated accordingly and should handle both this
# and the earlier form.

# As of SWIG version 1.3.2x, the corresponding attribute is now set in
# C code.
# The program has been updated to handle this case by adding an
# additional call 'this.disown()' to yield the ownership.

# The program does support multiple inheritance.

import string
import re
import sys

if len(sys.argv) > 1 and sys.argv[1]=='-v':
    verbose = 1
    del sys.argv[1]
else:
    verbose = 0

if len(sys.argv) < 2:
    print "Usage: python fixNet.py [-v] Net.py"
    sys.exit(1)

linecount = 0
matchclass = 0
replacementcount = 0
anyclass_regex = re.compile(r'^class (.*):')
class_regex = re.compile(r'^class (.*)\((.*)\):')
target_regex = re.compile(r'(\s*self\.thisown\s*=\s*)1')
target_regex1_3_19 = re.compile(r'(\s*_swig_setattr\(self, \w*, \'thisown\', )1(\)\s*)')
init_regex = re.compile(r'.*def __init__.*:')
create_regex1_3_2x = re.compile(r'.*this = _Net\.new_\w*\(\*args\)')
classes = ['Node']
try:
    f = open(sys.argv[1])
except IOError:
    sys.exit("Error: Cannot open '%s'" % sys.argv[1])
print """\
# This file was postprocessed after swig: The memory management of
# all objects returned by constructors of every class inherited from
# Node is handled by the Net they belong to instead of Python
# interpreter.
# See file fixNet.py for more information\n"""
for line in f:
    res = anyclass_regex.match(line)
    if res:
        matchclass = 0
        res = class_regex.match(line)
        if res:
            for superclass in res.group(2).split(','):
                if superclass in classes:
                    matchclass = 1
                    classes.append(res.group(1))
                    if verbose:
                        line += '# matched class\n'
    elif matchclass == 1:
        res = init_regex.match(line)
        if res:
            linecount = 0
            if verbose:
                line += '    # matched init\n'
	elif linecount == 1:
	    if create_regex1_3_2x.match(line):
		line += '        this.disown()\n'
		replacementcount += 1
		matchclass = 0
        elif linecount == 2:
            (line, count) = target_regex.subn('\g<1>0', line)
            if count == 0:
                (line, count) = target_regex1_3_19.subn('\g<1>0\g<2>', line)
            if count:
                if verbose:
                    line += '        # made the change\n'
                matchclass = 0
                replacementcount += 1
        linecount += 1
    print line,
f.close()

if replacementcount < 10:
    sys.exit("Suspiciously few replacements were made, maybe file format generated by SWIG could not be recognised")
