// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: Decay.h 5 2006-10-26 09:44:54Z ah $

#ifndef DECAY_H
#define DECAY_H

#include "Templates.h"
#include "Saver.h"
#include "Loader.h"
#include <set>

class Net;

class Decayer {
public:
  Decayer(Net *net) {
    decay_net = net;
  }
#ifndef BUILDING_SWIG_INTERFACE
  Decayer(Net *net, NetLoader *loader);
#endif
  virtual ~Decayer();
  virtual bool DoDecay(string hook) = 0;
  virtual void Save(NetSaver *saver);
  bool RegisterToHook(string hook) {
    decay_hooks.insert(hook);
    return true;
  }
  void EraseHook(string hook) { decay_hooks.erase(hook); }
  void UnregisterFromAllHooks();
private:
  std::set<string> decay_hooks;
  Net *decay_net;
};

#endif // DECAY_H
