// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: Saver.h 5 2006-10-26 09:44:54Z ah $

#ifndef SAVER_H
#define SAVER_H

#include "Templates.h"

class ConcreteSaver
{
public:
  virtual ~ConcreteSaver() {}
  virtual void SaveIt() = 0;
  virtual void StartEnumeratedContainer(int size, string name) = 0;
  virtual void StartNamedContainer(string name) = 0;
  virtual void CloseEnumeratedContainer(string name) = 0;
  virtual void CloseNamedContainer(string name) = 0;
  virtual void StartNode(string type) = 0;
  virtual void CloseNode(string type) = 0;
  virtual void SetDouble(double val) = 0;
  virtual void SetInt(int val) = 0;
  virtual void SetBool(bool val) = 0;
  virtual void SetString(string val) = 0;
  virtual void SetLabel(Label val) = 0;
  virtual void SetDV(DV val) = 0;
  virtual void SetDFlags(DFlags val) = 0;
  virtual void SetDSSet(DSSet val) = 0;
  virtual void SetDVSet(DVSet val) = 0;
  virtual void SetDVH(DVH val) = 0;
  virtual void SetDD(DD val) = 0;
  virtual void SetVDD(VDD val) = 0;
  virtual void SetIntV(IntV val) = 0;
  virtual void SetNamedDouble(string name, double val) = 0;
  virtual void SetNamedInt(string name, int val) = 0;
  virtual void SetNamedBool(string name, bool val) = 0;
  virtual void SetNamedString(string name, string val) = 0;
  virtual void SetNamedLabel(string name, Label val) = 0;
  virtual void SetNamedDV(string name, DV val) = 0;
  virtual void SetNamedDFlags(string name, DFlags val) = 0;
  virtual void SetNamedDSSet(string name, DSSet val) = 0;
  virtual void SetNamedDVSet(string name, DVSet val) = 0;
  virtual void SetNamedDVH(string name, DVH val) = 0;
  virtual void SetNamedDD(string name, DD val) = 0;
  virtual void SetNamedVDD(string name, VDD val) = 0;
  virtual void SetNamedIntV(string name, IntV val) = 0;
};

class NetSaver
{
public:
  NetSaver(ConcreteSaver *thesaver, bool debug = false)
  { saver = thesaver; debugsave = debug; }
  void SaveIt() { saver->SaveIt(); delete saver; saver = 0; }
  void StartNet(int size, string name) { saver->StartEnumeratedContainer(size, name); }
  void StartNode(string type) { saver->StartNode(type); }
  void FinishNet(string name) { saver->CloseEnumeratedContainer(name); }
  void FinishNode(string type) { saver->CloseNode(type); }
  void StartEnumCont(int size, string name) { saver->StartEnumeratedContainer(size, name); }
  void StartNamedCont(string name) { saver->StartNamedContainer(name); }
  void FinishEnumCont(string name) { saver->CloseEnumeratedContainer(name); }
  void FinishNamedCont(string name) { saver->CloseNamedContainer(name); }
  void SetDouble(double val) { saver->SetDouble(val); }
  void SetInt(int val) { saver->SetInt(val); }
  void SetBool(bool val) { saver->SetBool(val); }
  void SetString(string val) { saver->SetString(val); }
  void SetLabel(Label val) { saver->SetLabel(val); }
  void SetDV(DV val) { saver->SetDV(val); }
  void SetDFlags(DFlags val) { saver->SetDFlags(val); }
  void SetDSSet(DSSet val) { saver->SetDSSet(val); }
  void SetDVSet(DVSet val) { saver->SetDVSet(val); }
  void SetDVH(DVH val) { saver->SetDVH(val); }
  void SetDD(DD val) { saver->SetDD(val); }
  void SetVDD(VDD val) { saver->SetVDD(val); }
  void SetIntV(IntV val) { saver->SetIntV(val); }
  void SetNamedDouble(string name, double val) {
    saver->SetNamedDouble(name, val);
  }
  void SetNamedInt(string name, int val) {
    saver->SetNamedInt(name, val); 
  }
  void SetNamedBool(string name, bool val) {
    saver->SetNamedBool(name, val);
  }
  void SetNamedString(string name, string val) {
    saver->SetNamedString(name, val); 
  }
  void SetNamedLabel(string name, Label val) {
    saver->SetNamedLabel(name, val);
  }
  void SetNamedDV(string name, DV val) {
    saver->SetNamedDV(name, val);
  }
  void SetNamedDFlags(string name, DFlags val) {
    saver->SetNamedDFlags(name, val);
  }
  void SetNamedDSSet(string name, DSSet val) {
    saver->SetNamedDSSet(name, val);
  }
  void SetNamedDVSet(string name, DVSet val) {
    saver->SetNamedDVSet(name, val);
  }
  void SetNamedDVH(string name, DVH val) { 
    saver->SetNamedDVH(name, val); 
  }
  void SetNamedDD(string name, DD val) {
    saver->SetNamedDD(name, val);
  }
  void SetNamedVDD(string name, VDD val) {
    saver->SetNamedVDD(name, val);
  }
  void SetNamedIntV(string name, IntV val) {
    saver->SetNamedIntV(name, val);
  }
  bool GetSaveFunctionValue() { return debugsave; }

private:
  // If debugsave is false leaves out data from function nodes that can be
  // computed from other nodes.
  bool debugsave;
  ConcreteSaver *saver;
};

#endif // SAVER_H
