function C = covnan(A)
% same as cov, but leaving out NaNs.
% divides by zero, if matrix has too many missing values.

N = size(A, 2);

[s, n] = sumnan(A, 1);
B = A - repmat(s ./ n, size(A, 1), 1);
C = zeros(N);
for q=1:N,
  [s, n] = sumnan( repmat(B(:,q), 1, N) .* B, 1);
  C(q, :) = s ./ (n - 1);
end;

%  for w=1:size(B, 2),
%    [s, n] = sumnan(B(:, q) .* B(:, w), 1);
%    C(q,w) = s ./ (n - 1);
%  end;
