function [data, initsrc] = init_em(data, searchsources),
% A script for initialising the NDFA algorithm with embedding

% reunanen 2000-08-14
% Valpola 2000-08-29
% Honkela 2005-02-22

datadim = size(data,1);
datasampl = size(data,2);

n = 2;    % use x(t-2) ... x(t+2) as the data at time t
step = 1;

% form the embedding data
dataE = NaN*zeros(datadim*(2*n+1), datasampl+2*n*step);  
for k = 0:2*n
  dataE((k*datadim+1):((k+1)*datadim),(k*step+1):(k*step+datasampl)) = ...
      data;
end;
data = dataE(:,1+n*step:end-n*step);

% reduce embedding dimension with pca
[initsrc,data] = nanpca(data,searchsources);
