function [s, n] = sumnan(A, dim)
% calculates sum of matrix leaving out nan:s in direction dim.
% returns sum s and number of values not nan n.

[nan1, nan2] = find(isnan(A));
B = A;
if ~isempty(nan1),
  nans = sub2ind(size(A), nan1, nan2);
  B(nans) = 0;
end;
nnan = sum(isnan(A), dim);
s = sum(B, dim);
n = - nnan + size(A, dim);
