function [s, net] = update_s_and_net(s0, net0, lambda, smstep, netmstep)
% UPDATE_S_AND_NET  Update sources and network with given step

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

net = net0;
s = probdist(s0.e + lambda * smstep, s0.var);
net.w1 = probdist(net0.w1.e + lambda * netmstep.w1, ...
		  net0.w1.var);
net.b1 = probdist(net0.b1.e + lambda * netmstep.b1, ...
		  net0.b1.var);
net.w2 = probdist(net0.w2.e + lambda * netmstep.w2, ...
		  net0.w2.var);
net.b2 = probdist(net0.b2.e + lambda * netmstep.b2, ...
		  net0.b2.var);
