%
% Example of the use of Nonlinear factor analysis Matlab package
%

% Copyright (C) 1999-2004 Antti Honkela, Leo Lundqvist, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

% Generate the data for the helix
srcdim = 1;
nsampl = 1000;
noisestd = .05;

inputs = randn(srcdim, nsampl);
data = [cos(pi*inputs); sin(pi*inputs); inputs];
data = data + noisestd * randn(size(data));

% Visualize it
plot3(data(1,:), data(2,:), data(3,:), '.')
axis image
drawnow

% Parameters for iteration
hidneurons = 15;            % The number of hidden neurons to use
searchsources = 1;          % The number of sources to look for
iters = 1000;               % The number of iterations

% Do initialization and iterate
% (This may take some time...)
[res, x] = nlfa(data, 'searchsources', searchsources, ...
		'hidneurons', hidneurons, 'iters', iters);

% The results are returned in structures res.
% The reconstructions of the data are in probdist-matrix x.
% The reconstructions can then be plotted to the same picture
hold on;
plot3(x.m(1,:), x.m(2,:), x.m(3,:), 'r.')
