function x = feedfw(s0, net, approximation)
% FEEDFW  Do feedforward
%
%    Usage:
%      x = feedfw(s, net, approximation)
%      where x will be a cell array with intermediate results
%      from several phases of computation.

% Copyright (C) 1999-2004 Antti Honkela, Harri Valpola,
% and Xavier Giannakopoulos.
%
% This package comes with ABSOLUTELY NO WARRANTY; for details
% see License.txt in the program package.  This is free software,
% and you are welcome to redistribute it under certain conditions;
% see License.txt for details.

if nargin < 3,
  approximation = 'hermite';
end

%s = probdist(s0);
s = s0;
x = cell(1, 4);

sdim = size(s.m, 1);
tdim = size(s.m, 2);
hdim = size(net.w1.m, 1);
odim = size(net.w2.m, 1);

% Initialisation:         x{1} = s
x{1}.m = s.m;
x{1}.v = s.v;
x{1}.multi = repmat(eye(sdim), [1 1 tdim]);

% First linear layer:     x{2} = A*x{1} + a
x{2}.m = net.w1.m * x{1}.m + repmat(net.b1.m, [1, tdim]);
x{2}.extra = net.w1.v * (x{1}.m.^2 + x{1}.v) + ...
    repmat(net.b1.v, [1, tdim]);
x{2}.multi = reshape(net.w1.m * reshape(x{1}.multi, [sdim sdim*tdim]), ...
		     [hdim sdim tdim]);
x{2}.v = x{2}.extra + net.w1.m.^2 * x{1}.v;

% Nonlinear hidden layer: x{3} = phi(x{2})
if strcmp(approximation, 'hermite'),
  [x{3}, x{5}] = nonlin_hermite(x{2}, net.nonlin);
elseif strcmp(approximation, 'taylor'),
  x{3} = nonlin_taylor(x{2}, net.nonlin);
else
  error('Unsupported approximation')
end

% Second linear layer:    x{4} = B*x{3} + b
x{4}.m = net.w2.m * x{3}.m + repmat(net.b2.m, [1, tdim]);
x{4}.extra = net.w2.v * x{3}.m.^2 + ...
    net.w2.m.^2 * x{3}.extra + net.w2.v * x{3}.v + ...
    repmat(net.b2.v, [1, tdim]);
x{4}.multi = reshape(net.w2.m * reshape(x{3}.multi, [hdim sdim*tdim]), ...
		     [odim sdim tdim]);
x{4}.v = x{4}.extra + ...
    reshape(sum(repmat(shiftdim(x{1}.v, -1), [odim 1 1]) ...
		.* (x{4}.multi .^ 2), 2), [odim tdim]);
