// -*- C++ -*-  $Id: SMI.C,v 1.3 2014/01/16 15:17:03 jorma Exp $
// 
// Copyright 1998-2014 PicSOM Development Group <picsom@ics.aalto.fi>
// Aalto University School of Science
// PO Box 15400, FI-00076 Aalto, FINLAND
// 

#include "SMI.h"
#include <fstream>
#include <iostream>
#include <sstream>
#include <cstdlib>

//-----------------------------------------------------------------------------

SMI::SMI(const string& f) {
  if (f!="")
    read(f);
}

//-----------------------------------------------------------------------------

bool SMI::read(const string& f) {
  bool show = true;
  ifstream is(f.c_str());
  string line;
  for (;;) {
    getline(is, line);
    if (!is)
      break;
    // cout << line << endl;
    if (line[0]=='#' || line.find("Time")==0)
      continue;
    istringstream ss(line);
    vector<string> vv;
    for (;;) {
      string v;
      ss >> v;
      if (!ss)
	break;
      if (show)
	cout << "[" << v << "]";
      vv.push_back(v);
    }
    data[vv[29]] = vv;
    if (show)
      cout << endl;
    show = false;
    if (vv.size()<32)
      cout << vv.size() << " : " << line << endl;
  }

  return data.size();
}

//-----------------------------------------------------------------------------

const vector<string> *SMI::data_find(const string& t) const {
  map<string,vector<string> >::const_iterator p = data.find(t);
  return p==data.end() ? NULL : &p->second;
}

//-----------------------------------------------------------------------------

float SMI::data_float(const vector<string> *v, size_t i) const {
  if (!v)
    return -123456789;
  return atof((*v)[i].c_str());
}

//-----------------------------------------------------------------------------

pair<float,float> SMI::B_POR(const string& t) const {
  const vector<std::string> *v = data_find(t);
  float x = data_float(v,  9);
  float y = data_float(v, 10);
  return make_pair(x, y);
}

//-----------------------------------------------------------------------------

pair<float,float> SMI::B_POR(size_t cf) const {
  int fr = 24;
  int s  = (cf/fr)%60, f = cf%fr;
  int m  = (cf/(fr*60))%60, h = cf/(fr*3600);
  char b[100];
  sprintf(b, "%02d:%02d:%02d:%02d", h, m, s, f);

  return B_POR(b);
}

//-----------------------------------------------------------------------------

