// -*- C++ -*-  $Id: SMI.h,v 1.2 2014/01/16 15:17:17 jorma Exp $
// 
// Copyright 1998-2014 PicSOM Development Group <picsom@ics.aalto.fi>
// Aalto University School of Science
// PO Box 15400, FI-00076 Aalto, FINLAND
// 

#ifndef _SMI_H_
#define _SMI_H_

#include <string>
#include <vector>
#include <map>
using namespace std;

class SMI {
  ///

public:
  ///
  SMI(const string& = "");
  
  ///
  bool read(const string&);

  ///
  pair<float,float> B_POR(size_t) const;

  ///
  pair<float,float> B_POR(const string&) const;

protected:
  ///
  const vector<string> *data_find(const string&) const;

  ///
  float data_float(const vector<string>*, size_t) const;

  ///
  map<string,vector<string> > data;

}; // class SMI

#endif // _SMI_H_

