#ifndef SLMOTION_ANALYSIS_CONTROLLER
#define SLMOTION_ANALYSIS_CONTROLLER

#include "pythonapi.hpp"
#include "FeatureCreator.hpp"
#include "Analyser.hpp"
#include "CsvToEafConverter.hpp"

namespace slmotion {
  /**
   * This class controls the overall analysis process. 
   */
  class AnalysisController {
  public:
    /**
     * The main process.
     *
     * First, it will call each analyser in turn until the whole of the 
     * video has been analysed 
     *
     * @param analysers Analysers to call
     * @param skipFrames Number of frames to skip at the beginning
     * @param framesMax Maximum number of frames to process
     * @param storeImages If enabled, calls the I/O object to store image 
     * files to external storage.
     * @param combinationStyle The style in which multiple frames from
     * different analysers are combined (if at all)
     * @param pyEnv A pointer to the current python environment if available, or null
     */
    void analyseVideofiles(// std::vector<Analyser>& analysers,
                           Analyser& analyser,
                           size_t skipFrames,
                           size_t framesMax, 
                           bool storeImages,
                           // bool disableAnnotationBar,
                           const std::string& elanFilename,
                           const std::string& annTemplateFilename,
                           const std::string& inputFilename,
                           // Visualiser::CombinationStyle combinationStyle,
                           python::PythonEnvironment* pyEnv = nullptr,
                           UiCallback* uiCallback = nullptr,
                           const std::string& outTierXmlFile = "");
    


    AnalysisController(std::shared_ptr<Visualiser> visualiser,
                       std::shared_ptr<SLIO> slio, bool pauseMode) :
      pauseMode(pauseMode), visualiser(visualiser), slio(slio) { }


  private:
    /**
     * Visualises and stores the output frames from a single Analyser object
     *
     * @param anal Desired analyser object
     * @param frnumber Desired frame number
     * @param label PicSOM label
     * @param storeImages If true, the image will be stored to a file
     */
    void visualise(Analyser& anal, size_t frnumber, 
                   const std::string& label, 
                   bool storeImages) const;



    /**
     * Loops over analysers and gets visualisation result for the given 
     * frame from each analyser, then possibly stores the result or shows it
     * to the user
     *
     * @param frnumber Current frame number
     *
     * @return True if successful. False if process should be terminated.
     */
    void visualise(Analyser& analysers, size_t frnumber, 
		   const std::string& label,
                   bool storeImages); //, bool disableAnnotationBar);



    /**
     * A rather trivial function that simply reads in a key, and then acts
     * accordingly.
     *
     * @return Returns true if the user wants to quit
     */
    bool handleInput();



    bool pauseMode;
    std::shared_ptr<Visualiser> visualiser;
    std::shared_ptr<SLIO> slio;
    CsvToEafConverter csvToEafConverter;
  };
}
#endif
