#ifndef SLMOTION_ANALYSIS_RESULT
#define SLMOTION_ANALYSIS_RESULT

#include "Asm.hpp"
#include <set>
#include "TrackedPoint.hpp"

namespace slmotion {
  /**
   * Simple analysis results as produced by the analyser. These can be 
   * merged with other results later on.
   */
  struct AnalysisResult {
    /**
     * Points tracked by the KLT tracker
     */
    std::vector<std::set<TrackedPoint>> KLTPoints; ///< KLT location vectors from each frame, index 0 being the first frame
    std::vector< Asm::Instance > headASMs; ///< Likewise, but this time it's the ASM, the second member of the pair is the anchor
    std::vector< Asm::Instance > leftHandASMs; ///< Likewise, but this time it's the ASM
    std::vector< Asm::Instance > rightHandASMs; ///< Likewise, but this time it's the ASM
    size_t firstFrame; ///< First frame number (i.e. the frame number corresponding to the first index in the video file
    size_t lastFrame; ///< Similarly, the frame number in the video file corresponding to the last index in the vectors above
  };
}
#endif
