#ifndef SLMOTION_ANNOTATION
#define SLMOTION_ANNOTATION

#include <string>



namespace slmotion {
  /**
   * A simple struct to represent individual annotations
   */
  struct Annotation {
    std::string text; ///< A text for the annotation
    std::pair<int, int> timerefs; ///< The beginning and end time codes (in ms)

    /**
     * Creates a new annotation
     *
     * @param s The text
     * @param ref1 The first time code (in ms)
     * @param ref2 The last time code (in ms)
     */
    Annotation(const std::string& s, int ref1, int ref2) :
      text(s),
      timerefs(ref1, ref2)
    {}



    /**
     * Default constructor. Won't do anything smart.
     */
    Annotation() : timerefs(0, 0) {}



    /**
     * Annotations are ordered according to their beginning time
     */
    inline bool operator<(const Annotation& other) const {
      return this->timerefs.first < other.timerefs.first;
    }
  };



  /**
   * Reads in a line of text from the istream, and if the text is in the 
   * expected format, sets the annotation to match it.
   *
   * Sets an error flag to the stream on failure.
   *
   * The expected format is
   * <int> <int> <string>
   */
  std::istream& operator>>(std::istream& is, Annotation& ann);
}

#endif
