#include "BinaryClassifier.hpp"

using std::vector;

namespace slmotion {
 void  BinaryClassifier::estimateZNorm(const vector<vector<float> > &negSamples,
				       const vector<vector<float> > &posSamples,
				       const vector<bool> *dimMask) {


    size_t dim=posSamples[0].size();
    vector<size_t> activeDim;

    for(size_t d=0;d<dim;d++)
      if(dimMask==NULL || (*dimMask)[d]) activeDim.push_back(d);

    dim=activeDim.size();

 
  // pointers to data vectors
    vector<const vector<vector<float> > *> trainSamples(2);
    
    trainSamples[0] = &negSamples;
    trainSamples[1] = &posSamples;

    vector<size_t> classSizes(2);
    
    for(size_t cls=0;cls<2;cls++)
      classSizes[cls]=trainSamples[cls]->size();

    // estimate mean and variance of the components for normalisation

    mean=vector<float>(dim,0);
    variance=vector<float>(dim,0);
 
    int tgtsize=150000;
    
    int count=0;
    
    for(size_t cls=0;cls<2;cls++){
      size_t incr=classSizes[cls]/tgtsize;
      if(incr<1) incr=1;
      
      for(size_t i=0;i<classSizes[cls];i+=incr){
	const vector<float> *sptr=&((*trainSamples[cls])[i]);

	count++;
	//	for(int d=0;d<dim;d++){
	for (unsigned int d = 0; d<dim; ++d) {
	  mean[d] += (*sptr)[activeDim[d]];
	  variance[d] += (*sptr)[activeDim[d]]*(*sptr)[activeDim[d]];
	}
      }
    }

    // for(int d=0;d<dim;d++){
    for (unsigned int d = 0; d < dim; ++d) {
      mean[d] /= count;
      variance[d] /= count;
      variance[d] -= mean[d]*mean[d];
      
    }
 }

  void BinaryClassifier::estimateZNorm(const floatMatrix &m){

    mean=vector<float>(m.cols,0);
    variance=vector<float>(m.cols,0);

    for(int d=0;d<m.cols;d++)
      for(int s=0;s<m.rows;s++){
	float &v=m.dptr[s+d*m.rows];
	mean[d] += v;
	variance[d] += v*v;
      }
  
    if(m.rows>0){
      for (int d = 0; d < m.cols; d++) {
	mean[d] /= m.rows;
	variance[d] /= m.rows;
	variance[d] -= mean[d]*mean[d];
      }
    }
  }

  BinaryClassifier::~BinaryClassifier() {
  }
}

