#ifndef SLMOTION_BINARY_CLASSIFIER
#define SLMOTION_BINARY_CLASSIFIER

#include <vector>
#include <cstdlib>
#include "Classifier.hpp"

namespace slmotion {
  /**
   * An abstract base class for binary classifiers. 
   * Is trained with a data set, which updates the internal state of the
   * classifier.
   * After that, the prediction function can be called to output
   * the probability of the given sample to have label one.
   *
   * the dimMask argument, if specified, instructs the classifier to ignore
   * the feature vector components whose dimMask entry is false
   *
   * the training function has optional arguments for weighting the samples
   *
   *
   */
  class BinaryClassifier {
  public:
    virtual ~BinaryClassifier() = 0;

    virtual void train(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
		       const std::vector<bool> *dimMask=NULL,
		       const std::vector<float> *negWeights=NULL,
		       const std::vector<float> *posWeights=NULL) = 0;

    virtual float predict(const std::vector<float>  &sample,
			  const std::vector<bool> *dimMask=NULL)=0;

    void estimateZNorm(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
		       const std::vector<bool> *dimMask=NULL);

    void estimateZNorm(const floatMatrix &m);
    
    std::vector<float> mean; // for normalisation
    std::vector<float> variance;
  };
}
#endif
