#include "BlackBoardStdOutWriter.hpp"
#include "util.hpp"

namespace slmotion {
  static BlackBoardStdOutWriter DUMMY(true);

  void BlackBoardStdOutWriter::process(frame_number_t frnumber) {
    for (const std::string& s : dumpLabels) {
      if (getBlackBoard().has(frnumber, s)) {
        BlackBoardPointer<boost::any> item = getBlackBoard().get(frnumber, s);
        std::cout << s << ":" << frnumber << " " 
                  << anyToString(*item) << std::endl;
      }
    }
  }

  bool BlackBoardStdOutWriter::processRangeImplementation(frame_number_t first, 
                                                          frame_number_t last, 
                                                          UiCallback*) {
    for (const std::string& s : dumpLabels)
      if (getBlackBoard().has(s))
        std::cout << s << " " << anyToString(getBlackBoard().get(s)) 
                  << std::endl;
    for (frame_number_t f = first; f < last; ++f)
      process(f);
    return true;
  }


  Component* BlackBoardStdOutWriter::createComponentImpl(const boost::program_options::variables_map& opts, BlackBoard* blackBoard, FrameSource* frameSource) const {
    BlackBoardStdOutWriter b(blackBoard, frameSource);
    if (opts.count("stdout-dump-select")) {
      std::vector<std::string> labels;
      boost::split(labels, opts["stdout-dump-select"].as<std::string>(), 
                   boost::is_any_of(","));

      b.dumpLabels = std::set<std::string>(labels.begin(), labels.end());
    }
    return new BlackBoardStdOutWriter(b);
  }


  boost::program_options::options_description BlackBoardStdOutWriter::getCommandLineOptionsDescription() const {
    boost::program_options::options_description opts("BlackBoard StdOut Writer options");
    opts.add_options()("stdout-dump-select", 
                       boost::program_options::value<std::string>(),
                       "labels of blackboard data to dump (comma-separated)");
    return opts;
  }
}
