#ifndef SLMOTION_BLACKBOARD_STDOUT_WRITER
#define SLMOTION_DUMMY_COMPONENT

#include "Component.hpp"

namespace slmotion {
  class BlackBoardStdOutWriter : public Component {
  public:
    BlackBoardStdOutWriter(bool) : Component(true) { }

    BlackBoardStdOutWriter(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Dumps data to stdout";
    }

    virtual std::string getLongDescription() const {
      return "Stdout dump component";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "BlackBoardStdOutWriter";
    }

    virtual std::string getComponentName() const {
      return "Black Board stdout Writer";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const;

  protected:
    bool processRangeImplementation(frame_number_t first, 
                                    frame_number_t last, 
                                    UiCallback* uiCallback);

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

    std::set<std::string> dumpLabels; ///< labels to dump
  };
}

#endif

