#ifndef SLMOTION_BLOBTRACKER
#define SLMOTION_BLOBTRACKER

#include "Component.hpp"
#include "PropagationSkinDetector.hpp"

namespace slmotion {

  const std::string BLOBTRACKER_BLACKBOARD_ENTRY = "blobtracks";
  // for each frame this is of type map<int, vector<Rect> >
  // key to the map is the blobtracker id
  // the vector lists all the rectangles belonging to the track

  class BlobTracker : public Component {
  public:
    BlobTracker(bool) : Component(true) { }

    BlobTracker(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t /* frameNumber */){
      throw std::string("Processing of individual frames not supported"); 
    }

    bool processRangeImplementation(frame_number_t first,
                                    frame_number_t last,
                                    UiCallback* uiCallback);


    virtual std::string getShortDescription() const {
      return "Tracks separate skin blobs";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t { FACEDETECTOR_BLACKBOARD_ENTRY,
	  SKINDETECTOR_BLACKBOARD_MASK_ENTRY };
    }

    virtual property_set_t getProvided() const {
      return property_set_t { BLOBTRACKER_BLACKBOARD_ENTRY };
    }

    virtual std::string getShortName() const {
      return "BlobTracker";
    }

    virtual std::string getComponentName() const {
      return "Separate skin blob tracker";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }


 virtual boost::program_options::options_description getCommandLineOptionsDescription() const;


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

  };

}

#endif

