#include "BodyPartsFromBlobTracks.hpp"
#include "FaceDetector.hpp"
#include "SkinDetector.hpp"
#include "TrackingSkinDetector.hpp"

using std::cout;
using std::cerr;
using std::endl;
using cv::Mat;
using cv::Rect;
using std::vector;
using std::list;
using cv::Point;
using std::map;
using std::set;

namespace slmotion {
  static BodyPartsFromBlobTracks DUMMY(true);



  extern int debug;

  void BodyPartsFromBlobTracks::process(frame_number_t frameNumber) {
    if (slmotion::debug > 1)
      cerr << "Generating list of body parts based on blob tracks" << endl;

    if ( getBlackBoard().has(frameNumber, FACEDETECTOR_BLACKBOARD_ENTRY) &&
	 getBlackBoard().has(frameNumber, SKINDETECTOR_BLACKBOARD_MASK_ENTRY) &&
	 getBlackBoard().has(frameNumber, BLOBTRACKER_BLACKBOARD_ENTRY)){

      localBlackBoardType bb; 
      Rect face = *getBlackBoard().get<Rect>(frameNumber, 
                                             FACEDETECTOR_BLACKBOARD_ENTRY);
      //      localbb[std::pair<int,std::string>(n,"frame")]=getFrameSource()[n];
      bb[std::pair<int,std::string>(frameNumber,"skinmask")]=getBlackBoard().get<cv::Mat>(frameNumber, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);

      ensureUniqueBlobMaskOnBB(frameNumber,bb);
      Mat ulbl=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frameNumber,"uniqueblobmask")]);
      Mat skin=*boost::any_cast<cv::Mat>(&bb[std::pair<int,std::string>(frameNumber,"skinmask")]);


   //    cv::imshow("skin mask",skin);

      map<int,uchar> trackerid2lbl;
      map<uchar,set<int>> lbl2trackerid;

      // use tracker id -1 for head
      trackerid2lbl[-1]=ulbl.at<uchar>(0.5*(face.y+face.br().y),0.5*(face.x+face.br().x));
      lbl2trackerid[ulbl.at<uchar>(0.5*(face.y+face.br().y),0.5*(face.x+face.br().x))].insert(-1);

      BlackBoardPointer<map<int,vector<Rect> > > bt = getBlackBoard().get<map<int,vector<Rect> > >(frameNumber, BLOBTRACKER_BLACKBOARD_ENTRY);

      for(auto it=bt->begin(); it!=bt->end();it++){
	if(it->second.size()>0){
	  trackerid2lbl[it->first]=ulbl.at<uchar>(it->second.begin()->y+1,it->second.begin()->x+1);          
	  lbl2trackerid[ulbl.at<uchar>(it->second.begin()->y+1,it->second.begin()->x+1)].insert(it->first); 
	}
	
      }

  //     // dump collected information
//       cout << endl;
//       for(auto it=trackerid2lbl.begin();it!=trackerid2lbl.end();it++)
// 	cout << "trackerid2lbl["<<it->first<<"]="<<(int)(it->second)<<endl;

//       for(auto it=lbl2trackerid.begin();it!=lbl2trackerid.end();it++){
// 	cout << "tracker ids in blob " << (int)(it->first) << " :";
// 	for(auto it2=it->second.begin();it2!=it->second.end();it2++)
// 	  cout << " " << (int)(*it2);
// 	cout << endl;
//       }

      // go through tracker ids and make sure that each has
      // been assigned lh/rh label in internal cache

      // if not, guess the hand to be either left or right

      assert(trackerid2lbl.size()<=3); // frame with > 2 trackers causes error to be reported


      bool lh_assigned=false;
      bool rh_assigned=false;

      for(auto it=trackerid2lbl.begin(); it!=trackerid2lbl.end();it++){
	if(it->first==-1) continue;
	if(lh_cache.count(it->first)) lh_assigned=true;
	if(rh_cache.count(it->first)) rh_assigned=true;
      }
	
      for(auto it=trackerid2lbl.begin(); it!=trackerid2lbl.end();it++){
	if(it->first==-1) continue;
	if(lh_cache.count(it->first)) continue;
	if(rh_cache.count(it->first)) continue;

	// the tracker id has not been assigned hand before, do it now
 
	// the chosen left/righthandedness does not reflect reality, the labels are arbitrary

	if(lh_assigned){
	  rh_cache.insert(it->first);
	  rh_assigned=true;
	} else{
	  lh_cache.insert(it->first);
	  lh_assigned=true;
	}

      }

      


      vector<vector<Point>> contours;
      findContours(skin, contours, CV_RETR_EXTERNAL, CV_CHAIN_APPROX_SIMPLE);

      list<BodyPart> bodyParts;
      
      for(auto it=contours.begin();it!=contours.end();it++){
	if(it->size()<1) continue; 
	
	Blob blob(*it);

	uchar lbl=ulbl.at<uchar>((*it)[0].y,(*it)[0].x);

	set<int> trackerids=lbl2trackerid[lbl];
	if(trackerids.size()==0) continue;

	bool head_present=false;
	bool lh_present=false;
	bool rh_present=false;

	for(auto tit=trackerids.begin();tit!=trackerids.end();tit++){
	  if(*tit==-1) head_present=true;
	  else if(lh_cache.count(*tit)) lh_present=true;
	  else if(rh_cache.count(*tit)) rh_present=true;
	}

	BodyPart::PartName pname=BodyPart::UNKNOWN;

	if(trackerids.size()==1){
	  if(head_present) pname=BodyPart::HEAD;
	  else if(lh_present) pname=BodyPart::LEFT_HAND;
	  else if(rh_present) pname=BodyPart::RIGHT_HAND;
	} else if(trackerids.size()==2){
	  if(head_present){
	    if(lh_present) pname=BodyPart::LEFT_HAND_HEAD;
	    else if(rh_present) pname=BodyPart::RIGHT_HAND_HEAD;
	  } else
	    pname=BodyPart::LEFT_RIGHT_HAND;
	  
	} else if(trackerids.size()==3)
	    pname=BodyPart::LEFT_RIGHT_HAND_HEAD;
	  
	bodyParts.push_back(BodyPart(pname, false, blob));
      }

      getBlackBoard().set<list<BodyPart>>(frameNumber, BODYPARTCOLLECTOR_BLACKBOARD_ENTRY, bodyParts);
    }

    // for checking, visualise the part labelling

  //   Mat visframe=getFrameSource()[frameNumber].clone();
    
//     list<BodyPart> bodyParts=getBlackBoard().get<list<BodyPart>>(frameNumber, BODYPARTCOLLECTOR_BLACKBOARD_ENTRY);

//     for(auto it=bodyParts.begin();it!=bodyParts.end();it++){

//       cv::Scalar c;
//       switch(it->getIdentity()){
//       case BodyPart::UNKNOWN:
// 	c=CV_RGB(255,0,0);
// 	break;
//       case BodyPart::HEAD:
// 	c=CV_RGB(0,255,0);
// 	break;
//       case BodyPart::LEFT_HAND:
// 	c=CV_RGB(0,0,255);
// 	break;
//       case BodyPart::LEFT_HAND_HEAD:
// 	c=CV_RGB(0,255,255);
// 	break;
//       case BodyPart::RIGHT_HAND:
// 	c=CV_RGB(255,0,255);
// 	break;
//       case BodyPart::RIGHT_HAND_HEAD:	
// 	c=CV_RGB(255,255,0);
// 	break;
//       case BodyPart::LEFT_RIGHT_HAND:
// 	c=CV_RGB(255,128,128);
// 	break;
//       case BodyPart::LEFT_RIGHT_HAND_HEAD:
// 	c=CV_RGB(128,255,128);
// 	break;
//       case BodyPart::OTHER:
// 	c=CV_RGB(255,255,255);
// 	break;
//       }
	
//       it->getBlob().draw(visframe,c);
      
//     }

//     Rect face = getBlackBoard().get<Rect>(frameNumber, 
//                                           FACEDETECTOR_BLACKBOARD_ENTRY);

//     cv::rectangle(visframe,face,CV_RGB(100,255,100));

//     cv::imshow("body parts",visframe);
//     cv::waitKey(0);

  }



  Component* BodyPartsFromBlobTracks::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new BodyPartsFromBlobTracks(blackBoard, frameSource);
  }
}
