#ifndef SLMOTION_CLONABLE
#define SLMOTION_CLONABLE

namespace slmotion {
  /**
   * A trivial base class that can be inherited from whenever subclasses 
   * must be copied through a base class pointer.
   */
  class Clonable {
  public:
    /**
     * Returns a pointer to a new copy of the object that has been 
     * instantiated as the proper subclass.
     */
    virtual Clonable* clone() const = 0;
    virtual ~Clonable() {}
  };
}

#endif
