#include "ColourSpaceConverter.hpp"

namespace slmotion {
  static ColourSpaceConverter DUMMY(true);



  void ColourSpaceConverter::process(frame_number_t frameNumber) {
    cv::Mat temp;
    colourSpace->convertColour(getFrameSource()[frameNumber], temp);
    getBlackBoard().set(frameNumber, blackBoardEntry, temp);
  }



  boost::program_options::options_description 
  ColourSpaceConverter::getConfigurationFileOptionsDescription() const {
    boost::program_options::options_description conffileOpts;
    conffileOpts.add_options()
      ("ColourSpaceConverter.colourspace", 
       boost::program_options::value<std::string>()->default_value("gray"),
       "Possible values are gray | bgr\n"
       "Selects the target colour space\n");
    return conffileOpts;
  }



  Component* ColourSpaceConverter::createComponentImpl(const boost::program_options::variables_map& vm, BlackBoard* blackBoard, FrameSource* frameSource) const {
    if (vm.count("ColourSpaceConverter.colourspace")) {
      std::string cs = vm["ColourSpaceConverter.colourspace"].as<std::string>();
      if (cs == "gray")
        return new ColourSpaceConverter(blackBoard, frameSource,
                                        COLOURSPACECONVERTER_BLACKBOARD_GSIMAGE_ENTRY,
                                        *ColourSpace::GREY);
      else if (cs == "bgr")
        return new ColourSpaceConverter(blackBoard, frameSource,
                                        COLOURSPACECONVERTER_BLACKBOARD_GSIMAGE_ENTRY,
                                        *ColourSpace::BGR);
      else
        throw std::invalid_argument("Unsupported colour space!");
    } 
    return new ColourSpaceConverter(blackBoard, frameSource);
  }
}
