#ifndef SLMOTION_PYTHON_COMPONENT_SPECIFICATION
#define SLMOTION_PYTHON_COMPONENT_SPECIFICATION

#include <boost/python.hpp>
#include <boost/any.hpp>
#include <map>

namespace slmotion {
  namespace python {
    /**
     * The Components in Python are just specifications for creating
     * the corresponding actual C++ components. This class serves as
     * the base for the Python class.
     */
    class ComponentSpecification {
    public:
      /**
       * The simple constructor: just pass default options
       */
      explicit ComponentSpecification(const std::string& componentName) :
        componentName(componentName) {
      }


      /**
       * The typical constructor: the name of the component, and a
       * key-value dictionary that can be used to construct the actual
       * component.
       */
      ComponentSpecification(const std::string& componentName,
                             const boost::python::dict& opts);
      
      std::string componentName;
      std::map<std::string, boost::any> opts;
    };
  }
}
#endif
