#include "ConfigurationWindow.hpp"
#include "configuration.hpp"

#ifdef SLMOTION_WITH_QT
#include <QGridLayout>
#include <QCheckBox>
#include <QDialogButtonBox>
#include <QPushButton>
#endif // SLMOTION_WITH_QT

#include <fstream>

namespace po = boost::program_options;

namespace slmotion {
  namespace gui {
#if defined(SLMOTION_WITH_GTK)
    static void destroyWindow(GtkWidget*, gpointer window) {
      gtk_widget_destroy(GTK_WIDGET(window));
    }

    void ConfigurationWindow::saveConfiguration(GtkWidget*, gpointer ptr) {
      ConfigurationWindow* instance = reinterpret_cast<ConfigurationWindow*>(ptr);

      bool b = (bool)gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(instance->cacheButton));
      po::variable_value v(boost::any(b), false);
      auto p = std::make_pair(std::string("global.cacheframes"), v);
      if (instance->config.configurationVariables->count("global.cacheframes"))
        instance->config.configurationVariables->erase("global.cacheframes");
      instance->config.configurationVariables->insert(p);

      std::ofstream ofs(instance->conffile);
      slmotion::configuration::outputConfig(ofs, 80, instance->config.configurationVariables);
    }

    ConfigurationWindow::ConfigurationWindow(SingletonWindow** ptr,
                                             const std::string& conffile) :
      SingletonWindow(ptr),
      conffile(conffile) {

      if (conffile.length() > 0)
        config = slmotion::configuration::parseConfigurationFile(conffile);

      GtkWindow* window = getWindow();
      gtk_window_set_title(window, "Configure slmotion");

      GtkWidget* vbox = gtk_vbox_new(false, 2);      

      cacheButton = gtk_check_button_new_with_label("Cache analysed video frames");
      gtk_container_add(GTK_CONTAINER(vbox), cacheButton);

      GtkWidget* hbox = gtk_hbox_new(false, 2);
      GtkWidget* cancelButton = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
      GtkWidget* saveButton = gtk_button_new_from_stock(GTK_STOCK_SAVE);
      gtk_container_add(GTK_CONTAINER(hbox), cancelButton);
      gtk_container_add(GTK_CONTAINER(hbox), saveButton);
      gtk_container_add(GTK_CONTAINER(vbox), hbox);

      g_signal_connect(cancelButton, "clicked", G_CALLBACK(&destroyWindow), 
                       window);

      g_signal_connect(saveButton, "clicked", G_CALLBACK(&saveConfiguration), 
                       this);

      gtk_container_add(GTK_CONTAINER(window), vbox);
      gtk_widget_show_all(GTK_WIDGET(window));
    }
#elif defined(SLMOTION_WITH_QT)
    ConfigurationWindow::ConfigurationWindow(const std::string& conffile,
                                             const std::string& title) :
      conffile(conffile) {

      if (conffile.length() > 0)
        config = slmotion::configuration::parseConfigurationFile(conffile);

      setWindowTitle(QString::fromStdString(title));
      QGridLayout* layout = new QGridLayout;
      cacheBox = new QCheckBox("Cache analysed video frames");
      if (config.configurationVariables->count("global.cacheframes"))
        cacheBox->setChecked((*config.configurationVariables)["global.cacheframes"].as<bool>());

      layout->addWidget(cacheBox, 0, 0);
      QDialogButtonBox* buttons = 
        new QDialogButtonBox(QDialogButtonBox::Save | QDialogButtonBox::Cancel);
      layout->addWidget(buttons, 1, 0);
      setLayout(layout);

      QPushButton* saveButton = buttons->button(QDialogButtonBox::Save);
      connect(saveButton, SIGNAL(clicked()), this, SLOT(saveConfiguration()));
      QPushButton* cancelButton = buttons->button(QDialogButtonBox::Cancel);
      connect(cancelButton, SIGNAL(clicked()), this, SLOT(hide()));
    }



    void ConfigurationWindow::saveConfiguration() {
      bool b = cacheBox->isChecked();
      po::variable_value v(boost::any(b), false);
      auto p = std::make_pair(std::string("global.cacheframes"), v);
      if (config.configurationVariables->count("global.cacheframes"))
        config.configurationVariables->erase("global.cacheframes");
      config.configurationVariables->insert(p);

      std::ofstream ofs(conffile);
      slmotion::configuration::outputConfig(ofs, 80, *config.configurationVariables);      
    }
#endif // SLMOTION_WITH_QT
  }
}

