#ifndef SLMOTION_CONFIGURATION_WINDOW
#define SLMOTION_CONFIGURATION_WINDOW

#if defined(SLMOTION_WITH_GTK) && defined(SLMOTION_WITH_QT)
#error Only one kind of GUI can be enabled at a time!
#endif

#ifdef SLMOTION_ENABLE_PICSOM
// picsom must be included _before_ Qt
#include <DataBase.h>
#endif // SLMOTION_ENABLE_PICSOM

#include "SingletonWindow.hpp"
#include "SLMotionConfiguration.hpp"
#ifdef SLMOTION_WITH_QT
#include <QCheckBox>
#endif

namespace slmotion {
  namespace gui {
    /**
     * This class represents a window that can be used to configure
     * some global settings
     */
#if defined(SLMOTION_WITH_GTK)
    class ConfigurationWindow : public SingletonWindow {
#elif defined(SLMOTION_WITH_QT)
    class ConfigurationWindow : public QWidget {
      Q_OBJECT
#else // SLMOTION_WITH_QT
    class ConfigurationWindow {
#endif // SLMOTION_WITH_QT
    public:
#if defined(SLMOTION_WITH_GTK)
      ConfigurationWindow(SingletonWindow** ptr,
                          const std::string& conffile); 
#elif defined(SLMOTION_WITH_QT)
      ConfigurationWindow(const std::string& conffile,
                          const std::string& title); 
#endif // SLMOTION_WITH_QT

      virtual ~ConfigurationWindow() {}

#ifdef SLMOTION_WITH_QT
    private slots:
      void saveConfiguration();
#endif // SLMOTION_WITH_QT
    private:
#ifdef SLMOTION_WITH_GTK
      static void saveConfiguration(GtkWidget*, gpointer);
#endif // SLMOTION_WITH_GTK

      std::string conffile;
      slmotion::configuration::SLMotionConfiguration config;
#if defined(SLMOTION_WITH_GTK)
      GtkWidget* cacheButton;
#elif defined(SLMOTION_WITH_QT)
      QCheckBox* cacheBox;
#endif // SLMOTION_WITH_QT
    };
  }
}

#endif
