#ifndef SLMOTION_CSV_IMPORTER
#define SLMOTION_CSV_IMPORTER

#include "Component.hpp"

namespace slmotion {
  /**
   * This component reads in CSV files according to user-set specifications.
   * The results are stored as vectors of floats on the Black Board.
   */
  class CsvImporter : public Component {
  public:
    CsvImporter(bool) : Component(true) { }

    CsvImporter(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Reads in CSV files";
    }

    virtual std::string getLongDescription() const {
      return "This component reads in the given CSV files and stores their "
        "content as vectors of floats. The user must specify which fields are"
        " to be stored.";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual property_set_t getProvided() const;

    virtual std::string getShortName() const {
      return "CsvImporter";
    }

    virtual std::string getComponentName() const {
      return "CSV File Importer";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const;

    /**
     * Reads in all CSV data and stores it on the Black
     * Board. However, frame ranges are ignored.
     */
    virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
                                            UiCallback* uiCallback);

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    std::vector<std::string> filenames;
    // a vector of specs, each of which is
    //   a vector of key/index-vector pairs
    std::vector< std::vector< std::pair<std::string,std::vector<size_t> > > > specs;
  };



  class CsvException : public SLMotionException {
  public:
    /**
     * A simple constructor
     *
     * @param msg An explanatory message
     */
    explicit CsvException(const char* msg) :
      SLMotionException(msg)
    {}



    explicit CsvException(const std::string& msg) :
      SLMotionException(msg.c_str())
    {}



    virtual ~CsvException() throw() {}
  };
}

#endif

