#include "DataSet.hpp"
#include <iostream>
#include <cstring>

using std::cerr;
using std::endl;
using std::cout;
using std::vector;

namespace slmotion {
  void DataSet::read(const std::string& fn) {
    
    const int LINELENGTH=10000;
    
    FILE *dat;
    
    if((dat=fopen(fn.c_str(),"r"))==NULL){
      cerr << "Failed to open " << fn << " for reading." << endl;
      exit(-1);
    }
    
    
    int dim;
    
    char line[LINELENGTH];
    
    while(!feof(dat)){
      if(!fgets(line,LINELENGTH,dat)){
	cerr << "error reading dat file" << endl;
	exit(-1);
      }
      
      //    cerr <<"READ LINE:" <<endl << line;
      
      if(line[0]=='#'){
	while(line[strlen(line)-1] != '\n'){ fgets(line,LINELENGTH,dat);}
	continue;
      }
      
      if(sscanf(line,"%d",&dim) != 1){
	cerr << "couldn't parse dimension from first line: " << endl;
	cerr << line;
	exit(-1);
      }
      
      cerr << "Read info line " << line << endl;
      
      this->dim=dim;
      
      int readdatavec=0;
      
      while(!feof(dat)){
	if(!fgets(line,LINELENGTH,dat)){
	  break;
	  //cerr << "error reading dat file" << endl;
	  //exit(1);
	}
	
	// cerr <<"READ LINE:" <<endl << line;
	
	if(line[0]=='#'){
	  while(line[strlen(line)-1] != '\n'){ fgets(line,LINELENGTH,dat);}
	  continue;
	}
	
	vector<float> v(dim);
	
	int offset=0;
	for(int i=0;i<dim;i++){
	  while(line[offset] && isspace(line[offset])) offset++;
	  if(sscanf(line+offset,"%f",&(v[i])) != 1){
	    cerr << "data reading error, line=" << line<<endl;
	    fclose(dat);
	    exit(-1);
	  }
	  while(line[offset] && !isspace(line[offset])) offset++;
	}
	
	
	//	if(v.size()==dim){
	if (v.size() == static_cast<size_t>(dim)) {
	  vec.push_back(v);
	  
	  //      char lblstr[80];
	  //      if(sscanf(line+offset,"%s",lblstr) != 1)
	  //	labels.push_back("");
	  //      else
	  //	labels.push_back(lblstr);
	  
	  readdatavec++;}
	
      }
      
      cout << "dataset: read " << readdatavec 
	   << " data vectors, dim= " << dim << endl;
    }
    
    fclose(dat);   
  }
}
